/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.validation;

import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.validation.ValidationFunction;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValidationService {
    public static final String FULL_JOB_KEY_REGEXP = "[A-Z][A-Z0-9]{1,}(-[A-Z][A-Z0-9]{1,}){2,2}";
    public static final String CHAIN_KEY_REGEXP = "[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}";
    public static final String PROJECT_KEY_REGEXP = BambooConstantUtils.preventInlining("[A-Z][A-Z0-9]{1,}");
    public static final String PARTIAL_JOB_KEY_REGEXP = "[A-Z][A-Z0-9]{1,}";

    @NotNull
    public ErrorCollection validateKey(@NotNull String var1, @NotNull ValidationType var2, @Nullable String var3, ValidationFunction ... var4);

    @NotNull
    public ErrorCollection validateJobKey(@NotNull String var1, @Nullable String var2, ValidationFunction ... var3);

    @NotNull
    public ErrorCollection validateChainKey(@NotNull String var1, @Nullable String var2, ValidationFunction ... var3);

    @NotNull
    public ErrorCollection validateProjectKey(@NotNull String var1, @Nullable String var2, ValidationFunction ... var3);

    @NotNull
    public ErrorCollection validateName(@NotNull String var1, @NotNull String var2, @Nullable String var3);

    @NotNull
    public ErrorCollection validateDescription(@NotNull String var1, @Nullable String var2);

    public static enum ValidationType {
        JOB("job", "[A-Z][A-Z0-9]{1,}(-[A-Z][A-Z0-9]{1,}){2,2}"),
        CHAIN("chain", "[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}"),
        PROJECT("project", PROJECT_KEY_REGEXP);

        private String errorPrefix;
        private Pattern keyPattern;

        private ValidationType(String errorPrefix, String keyRegex) {
            this.errorPrefix = errorPrefix;
            this.keyPattern = Pattern.compile(keyRegex);
        }

        @NotNull
        public String getErrorPrefix() {
            return this.errorPrefix;
        }

        @NotNull
        public Pattern getKeyPattern() {
            return this.keyPattern;
        }
    }
}

