/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.module;

import com.atlassian.bamboo.vcs.BambooSpecsHandler;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.converter.Repository2VcsTypeConverter;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsRepositoryManager {
    @NotNull
    public List<VcsRepositoryModuleDescriptor> getAvailableRepositoryDescriptors();

    @Nullable
    public VcsRepositoryModuleDescriptor getVcsRepositoryModuleDescriptor(@NotNull String var1);

    @Deprecated
    @NotNull
    public List<VcsRepositoryModuleDescriptor> getAvailableStandaloneRepositoryDescriptors();

    @Nullable
    public VcsRepositoryModuleDescriptor getRepositoryModuleDescriptorByMavenScmKey(@NotNull String var1, @NotNull String var2);

    @Nullable
    public Repository2VcsTypeConverter findConverterFor(@NotNull String var1);

    @Nullable
    public Repository2VcsTypeConverter findReverseConverterFor(@NotNull String var1);

    default public boolean supportsDivergentBranches(@NotNull String pluginKey) {
        return Optional.ofNullable(this.getVcsRepositoryModuleDescriptor(pluginKey)).map(VcsRepositoryModuleDescriptor::getBambooSpecsHandler).map(BambooSpecsHandler::supportsDivergentBranches).orElse(false);
    }

    default public boolean divergentBranchesEnabled(@NotNull VcsRepositoryData vcsRepositoryData) {
        return Optional.ofNullable(this.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey())).map(VcsRepositoryModuleDescriptor::getBambooSpecsHandler).map(bambooSpecsHandler -> bambooSpecsHandler.divergentBranchesEnabled(vcsRepositoryData)).orElse(false);
    }
}

