/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.runtime;

import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;

public class ContextualVcsId<T extends IdentifyingExecutor<?>> {
    private final T executor;
    private final VcsRepositoryData sourceData;
    private final String[] ids;
    private final Supplier<String> hash = Suppliers.memoize((Supplier)new Supplier<String>(){

        public String get() {
            if (ContextualVcsId.this.ids.length == 1) {
                return ContextualVcsId.this.ids[0];
            }
            return ContextualVcsId.calculateAggregateSha(ContextualVcsId.this.ids);
        }
    });

    private static String calculateAggregateSha(String[] params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String param : params) {
            if (param != null) {
                try {
                    baos.write(param.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot happen: Error writing string to byte array", e);
                }
            }
            baos.write(0);
        }
        return DigestUtils.sha1Hex((byte[])baos.toByteArray());
    }

    public ContextualVcsId(T executor, VcsRepositoryData sourceData, String ... ids) {
        this.executor = executor;
        this.sourceData = sourceData;
        this.ids = ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualVcsId vcsId = (ContextualVcsId)o;
        if (!this.sourceData.getPluginKey().equals(vcsId.sourceData.getPluginKey())) {
            return false;
        }
        return Arrays.equals(this.ids, vcsId.ids);
    }

    public T getExecutor() {
        return this.executor;
    }

    public VcsRepositoryData getSourceData() {
        return this.sourceData;
    }

    public String toString() {
        return (String)this.hash.get();
    }

    public String toDebugString() {
        return "ContextualVcsId{ids=" + Arrays.toString(this.ids) + ", pluginKey=" + this.sourceData.getPluginKey() + "}";
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.ids) + this.sourceData.getPluginKey().hashCode();
    }
}

