/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.deployments.DeploymentKey;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class DeploymentKeys {
    private DeploymentKeys() {
    }

    public static long getEnvironmentIdFromResultKey(@NotNull ResultKey resultKey) {
        return DeploymentKeys.getEnvironmentIdFromKey(resultKey.getEntityKey());
    }

    public static long getDeploymentIdFromResultKey(@NotNull ResultKey resultKey) {
        return DeploymentKeys.getDeploymentIdFromKey(resultKey.getEntityKey());
    }

    public static long getDeploymentIdFromKey(@NotNull Key key) {
        Preconditions.checkArgument((boolean)(key instanceof DeploymentKey), (Object)"Not a deployment key");
        return Long.parseLong(StringUtils.split((String)key.getKey(), (char)'-')[0]);
    }

    public static long getEnvironmentIdFromKey(@NotNull Key key) {
        Preconditions.checkArgument((boolean)(key instanceof DeploymentKey), (Object)"Not a deployment key");
        return Long.parseLong(StringUtils.split((String)key.getKey(), (char)'-')[1]);
    }
}

