/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.execution.events;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bamboo.deployments.execution.events.AbstractDeploymentEvent;
import com.atlassian.event.api.AsynchronousPreferred;
import java.io.Serializable;
import java.sql.Timestamp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AsynchronousPreferred
@EventName(value="bamboo.deployment.finished")
public class DeploymentFinishedEvent
extends AbstractDeploymentEvent
implements Serializable {
    private final Timestamp timestamp;
    private final String resultKey;

    public DeploymentFinishedEvent(long deploymentResultId) {
        super(deploymentResultId);
        this.resultKey = null;
        this.timestamp = new Timestamp(System.currentTimeMillis());
    }

    public DeploymentFinishedEvent(long deploymentResultId, @NotNull String resultKey, @NotNull Timestamp timestamp) {
        super(deploymentResultId);
        this.timestamp = timestamp;
        this.resultKey = resultKey;
    }

    @NotNull
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getResultKey() {
        return this.resultKey;
    }

    public String toString() {
        return "DeploymentFinishedEvent{deploymentResultId='" + this.getDeploymentResultId() + "', resultKey='" + (this.resultKey != null ? this.resultKey : "UNDEFINED") + "', timestamp=" + String.valueOf(this.timestamp) + "}";
    }
}

