/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.versions.service;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.versions.DeploymentVersion;
import com.atlassian.bamboo.deployments.versions.DeploymentVersionState;
import com.atlassian.bamboo.deployments.versions.DeploymentVersionStatus;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.atlassian.user.User;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DeploymentVersionService {
    @NotNull
    public ErrorCollection validateCreateDeploymentVersion(long var1, @NotNull PlanResultKey var3, @Nullable String var4, @Nullable String var5);

    public boolean isVersionNameConflicting(long var1, @NotNull String var3);

    @NotNull
    public ErrorCollection validateDeploymentVersionRename(long var1, @NotNull DeploymentVersion var3, @Nullable String var4);

    @Deprecated
    @NotNull
    public DeploymentVersion createDeploymentVersion(long var1, @NotNull PlanResultKey var3) throws WebValidationException;

    @NotNull
    public DeploymentVersion getOrCreateDeploymentVersion(long var1, @NotNull PlanResultKey var3) throws WebValidationException;

    @NotNull
    public DeploymentVersion createDeploymentVersion(long var1, @NotNull PlanResultKey var3, @Nullable User var4, @Nullable String var5, @Nullable String var6) throws WebValidationException;

    @Nullable
    public DeploymentVersion getDeploymentVersion(long var1);

    @NotNull
    public Set<String> getResultPlanKeysHavingDeploymentProjectVersions(long var1);

    @Deprecated
    @NotNull
    public List<DeploymentVersion> getDeploymentProjectVersions(long var1);

    @Deprecated
    @NotNull
    public List<DeploymentVersion> searchVersionsByName(long var1, @NotNull String var3);

    @Deprecated
    @NotNull
    public List<DeploymentVersion> searchVersionsByBranch(long var1, @NotNull PlanKey var3);

    @Deprecated
    @NotNull
    public List<DeploymentVersion> searchVersionsByBranchAndName(long var1, @NotNull PlanKey var3, @NotNull String var4);

    @NotNull
    public List<DeploymentVersion> searchVersionsByNameNoVariables(@NotNull DeploymentProject var1, @NotNull String var2);

    @NotNull
    public List<DeploymentVersion> searchVersionsByNameNoVariables(@NotNull DeploymentProject var1, @NotNull String var2, int var3, int var4, @NotNull DeploymentVersionNeededAttributes var5);

    @NotNull
    public List<DeploymentVersion> searchVersionsByBranchNoVariables(@NotNull DeploymentProject var1, @NotNull PlanKey var2);

    @NotNull
    public List<DeploymentVersion> searchVersionsByBranchNoVariables(@NotNull DeploymentProject var1, @NotNull PlanKey var2, int var3, int var4);

    @NotNull
    public List<DeploymentVersion> searchVersionsByBranchNoVariables(@NotNull DeploymentProject var1, @NotNull PlanKey var2, int var3, int var4, @NotNull DeploymentVersionNeededAttributes var5);

    @NotNull
    public List<DeploymentVersion> searchVersionsByBranchAndNameNoVariables(@NotNull DeploymentProject var1, @NotNull PlanKey var2, @NotNull String var3);

    @NotNull
    public List<DeploymentVersion> searchVersionsByBranchAndNameNoVariables(@NotNull DeploymentProject var1, @NotNull PlanKey var2, @NotNull String var3, int var4, int var5, @NotNull DeploymentVersionNeededAttributes var6);

    @Nullable
    public DeploymentVersion getDeploymentVersionByName(@NotNull String var1, long var2);

    public Set<PlanResultKey> getRelatedPlanResultKeys(long var1);

    @NotNull
    public Map<Long, PlanResultKey> getRelatedPlanResultKeys(@NotNull Set<Long> var1);

    public boolean isFromTheSameBranch(long var1, long var3);

    public boolean isFromTheSameBranch(String var1, long var2);

    @NotNull
    public DeploymentVersionStatus updateVersionStatus(long var1, @NotNull DeploymentVersionState var3, @NotNull String var4);

    @Deprecated
    @Nullable
    public DeploymentVersionStatus getLatestVersionStatus(long var1);

    @NotNull
    public List<DeploymentVersionStatus> getAllUsersLatestVersionStatusDtosOrderedByCreationDate(long var1);

    @Deprecated
    @NotNull
    public List<DeploymentVersion> findVersionsBetween(long var1, @NotNull DeploymentVersion var3, @NotNull DeploymentVersion var4);

    @NotNull
    public List<DeploymentVersion> findVersionsBetweenNoVariables(@NotNull long var1, @NotNull DeploymentVersion var3, @NotNull DeploymentVersion var4);

    @Nullable
    public DeploymentVersion findPreviousVersion(long var1, long var3);

    public int getVersionsCount();

    public int getVersionsCountForProject(long var1);

    public int getVersionsCountForProjectAndBranch(long var1, @NotNull PlanKey var3);

    @NotNull
    public List<DeploymentVersion> getDeploymentProjectVersionsNoVariables(@NotNull DeploymentProject var1);

    @NotNull
    public List<DeploymentVersion> getDeploymentProjectVersionsNoVariables(@NotNull DeploymentProject var1, int var2, int var3);

    @NotNull
    public List<DeploymentVersion> getDeploymentProjectVersionsNoVariables(@NotNull DeploymentProject var1, int var2, int var3, @NotNull DeploymentVersionNeededAttributes var4);

    @Deprecated
    @Nullable
    public DeploymentVersion getLatestVersionForProject(long var1);

    @Nullable
    public DeploymentVersion getLatestVersionForProject(long var1, @NotNull PlanKey var3);

    @NotNull
    public Multimap<String, Artifact> getVersionArtifacts(@NotNull DeploymentVersion var1);

    @Nullable
    public DeploymentVersion getRelatedVersion(long var1, @NotNull PlanResultKey var3);

    public DeploymentVersion findNextVersionContainingResult(long var1, @NotNull PlanResultKey var3);

    @NotNull
    public Map<String, VariableDefinitionContext> getPossibleVersionVariables(@NotNull ImmutablePlan var1, boolean var2);

    @NotNull
    public Map<String, VariableDefinitionContext> getPossibleVersionVariables(@NotNull ImmutablePlan var1, @Nullable PlanResultKey var2, boolean var3);

    @NotNull
    public String getIncrementedVersionName(@NotNull String var1);

    @NotNull
    public String getEvaluatedVersionName(String var1, Map<String, VariableDefinitionContext> var2, Set<String> var3);

    public void updatePlanKey(@NotNull PlanKey var1, @NotNull PlanKey var2);

    @NotNull
    public DeploymentVersion renameVersion(long var1, @NotNull DeploymentVersion var3, @NotNull String var4) throws WebValidationException;

    @NotNull
    public List<DeploymentVersion> findVersionsAssociatedWithJiraIssue(long var1, @NotNull String var3);

    @NotNull
    public Multimap<DeploymentProject, DeploymentVersion> findVersionsAssociatedWithJiraIssue(@NotNull String var1);

    @Internal
    @NotNull
    public Multimap<DeploymentProject, Pair<Long, PlanResultKey>> findVersionIdentifiersAssociatedWithJiraIssue(@NotNull String var1);

    @NotNull
    public Map<DeploymentVersion, Integer> findLatestKnownVersionsForEnvironmentsOfDeploymentProject(DeploymentProject var1);

    public boolean hasVersionsUnrelatedToBranch(long var1, @NotNull PlanKey var3);

    @NotNull
    public List<VariableSubstitutionContext> getVariableContextForVersion(@NotNull long var1);

    public String getVersionNamePreview(ResultsSummary var1, String var2);

    public void resetVersionsAge(@NotNull DeploymentVersion var1);

    @Deprecated
    @NotNull
    public Map<Long, DeploymentVersionStatus> getLatestVersionStatuses(@NotNull List<Long> var1);

    @NotNull
    public Map<Long, List<DeploymentVersionStatus>> getAllUsersLatestVersionStatusesOrderedByCreationDate(@NotNull List<Long> var1);

    public void updateVersionsForResult(@NotNull PlanResultKey var1);

    public static class DeploymentVersionNeededAttributes {
        boolean creatorDisplayName = true;
        boolean deploymentVersionItems = true;
        boolean operations = true;

        private DeploymentVersionNeededAttributes() {
        }

        public static DeploymentVersionNeededAttributes allNeededDefault() {
            return new DeploymentVersionNeededAttributes();
        }

        public boolean isCreatorDisplayName() {
            return this.creatorDisplayName;
        }

        public DeploymentVersionNeededAttributes setCreatorDisplayName(boolean creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
            return this;
        }

        public boolean isDeploymentVersionItems() {
            return this.deploymentVersionItems;
        }

        public DeploymentVersionNeededAttributes setDeploymentVersionItems(boolean deploymentVersionItems) {
            this.deploymentVersionItems = deploymentVersionItems;
            return this;
        }

        public boolean isOperations() {
            return this.operations;
        }

        public DeploymentVersionNeededAttributes setOperations(boolean operations) {
            this.operations = operations;
            return this;
        }
    }
}

