/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.deployments.DeploymentKey;
import com.atlassian.bamboo.deployments.DeploymentKeyWithIds;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Immutable
public class DeploymentKeyImpl
implements DeploymentKeyWithIds,
Comparable<Key> {
    private static final Logger log = Logger.getLogger(DeploymentKeyImpl.class);
    private static final char SEP = '-';
    protected final String key;
    private volatile transient boolean validated;

    public DeploymentKeyImpl(String key) {
        this.key = key;
        this.getKey();
    }

    @Override
    public long getDeploymentProjectId() {
        String[] parts = this.doSplit();
        return Long.parseLong(parts[0]);
    }

    @Override
    public long getEnvironmentId() {
        String[] parts = this.doSplit();
        return Long.parseLong(parts[1]);
    }

    @NotNull
    public String getKey() {
        if (!this.validated) {
            PlanKeys.assertSafeKey((String)this.key);
            this.validated = true;
        }
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        DeploymentKey deploymentKey = (DeploymentKey)Narrow.downTo((Object)o, DeploymentKey.class);
        return deploymentKey != null && this.key.equals(deploymentKey.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(Key key) {
        return new CompareToBuilder().append((Object)this.key, (Object)key.getKey()).toComparison();
    }

    public String toString() {
        return this.getKey();
    }

    private String[] doSplit() {
        String[] parts = StringUtils.split((String)this.key, (char)'-');
        Preconditions.checkState((parts.length == 2 ? 1 : 0) != 0);
        return parts;
    }
}

