/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.environments.persistence;

import com.atlassian.bamboo.deployments.DeploymentKey;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.environments.dashboard.EnvironmentStub;
import com.atlassian.bamboo.deployments.environments.dto.EnvironmentWithProjectAndRequirementsDto;
import com.atlassian.bamboo.deployments.environments.persistence.MutableEnvironment;
import com.atlassian.bamboo.deployments.projects.persistence.MutableDeploymentProject;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EnvironmentDao {
    @Nullable
    public MutableEnvironment getEnvironment(long var1);

    @Nullable
    public MutableEnvironment getEnvironment(@NotNull DeploymentKey var1);

    public void save(@NotNull MutableEnvironment var1);

    public <E extends MutableEnvironment> void saveAll(@NotNull Collection<E> var1);

    @NotNull
    public List<MutableEnvironment> getEnvironmentsForDeploymentProject(long var1);

    public void delete(@NotNull MutableEnvironment var1);

    @NotNull
    public List<EnvironmentStub> getEnvironmentStubsForDeploymentProject(long var1);

    public boolean isEnvironmentNameConflicting(@NotNull MutableDeploymentProject var1, @NotNull String var2);

    public List<MutableEnvironment> findAll();

    public int getLastEnvironmentPosition(long var1);

    public int getFirstEnvironmentPosition(long var1);

    public int getEnvironmentCount();

    public int getEnvironmentCountForProject(long var1);

    public long countAll();

    @NotNull
    public List<? extends MutableEnvironment> findAll(int var1, int var2);

    @NotNull
    public List<InternalEnvironment> findAllInternalEnvironments(int var1, int var2);

    @NotNull
    public List<InternalEnvironment> getInternalEnvironmentsForDeploymentProject(long var1);

    @Nullable
    public InternalEnvironment findInternalEnvironmentByName(long var1, @NotNull String var3);

    @NotNull
    public List<EnvironmentStub> findAllStubs(int var1, int var2);

    @NotNull
    public List<Pair<Requirement, MutableEnvironment>> findEnvironmentsByRequirementKey(@NotNull String var1);

    @NotNull
    public MutableEnvironment createNewEnvironmentInstance();

    @Nullable
    public MutableEnvironment findEnvironmentByName(long var1, String var3);

    @NotNull
    public List<MutableEnvironment> getPaginatedEnvironmentsForDeploymentProject(long var1, int var3, int var4, String var5);

    public List<EnvironmentWithProjectAndRequirementsDto> getPaginatedDeploymentsWithEnvironmentsOnlyIdsAndRequirementSets(int var1, int var2, String var3);

    public void shiftUpEnvPosition(int var1, int var2, long var3);

    public void shiftDownEnvPosition(int var1, int var2, long var3);

    public Optional<MutableEnvironment> getNextEnvironment(long var1, int var3);

    public Optional<MutableEnvironment> getPreviousEnvironment(long var1, int var3);

    @NotNull
    public List<MutableEnvironment> findAllByIds(Collection<Long> var1);

    @NotNull
    public List<InternalEnvironment> findInternalEnvironmentsByIds(@NotNull List<Long> var1);
}

