/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.execution.events;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.deployments.DeploymentResultKey;
import com.atlassian.bamboo.deployments.DeploymentResultKeyImpl;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.deployments.execution.events.DeploymentTimingPoint;
import com.atlassian.bamboo.util.Narrow;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class DeploymentTimingPoints
implements DeploymentTimingPoint {
    private static final Logger log = Logger.getLogger(DeploymentTimingPoints.class);
    private final Date date;
    private final DeploymentResultKey deploymentResultKey;
    private final long deploymentResultId;

    protected DeploymentTimingPoints(@NotNull ResultKey resultKey, @NotNull Date date) {
        DeploymentResultKey depKeyArg = (DeploymentResultKey)Narrow.downTo((Object)resultKey, DeploymentResultKey.class);
        this.deploymentResultKey = depKeyArg != null ? depKeyArg : DeploymentResultKeyImpl.from(resultKey.getKey());
        this.deploymentResultId = this.deploymentResultKey.getDeploymentResultId();
        this.date = date;
    }

    public static ExecutionCancelled executionCancelled(@NotNull ResultKey resultKey, @NotNull Date date, boolean buildActuallyCancelled) {
        return new ExecutionCancelled(resultKey, date, buildActuallyCancelled);
    }

    public static Queued queued(@NotNull DeploymentContext context, @NotNull Date date) {
        return new Queued(context.getResultKey(), date);
    }

    public static SentToAgent sentToAgent(@NotNull DeploymentContext context, @NotNull Date date, long agentId) {
        return new SentToAgent(context.getResultKey(), date, agentId);
    }

    public static AgentAssigned agentAssigned(@NotNull DeploymentContext context, @NotNull Date date, long agentId) {
        return new AgentAssigned(context.getResultKey(), date, agentId);
    }

    public static ExecutionStarted executionStarted(@NotNull DeploymentContext context, @NotNull Date date) {
        return new ExecutionStarted(context.getResultKey(), date);
    }

    public static ExecutionFinished executionFinished(@NotNull DeploymentContext context, @NotNull Date date) {
        return new ExecutionFinished(context.getResultKey(), date);
    }

    @NotNull
    public Date getDate() {
        return this.date;
    }

    @Override
    public long getDeploymentResultId() {
        return this.deploymentResultId;
    }

    @Override
    @NotNull
    public DeploymentResultKey getResultKey() {
        return this.deploymentResultKey;
    }

    public static class ExecutionCancelled
    extends DeploymentTimingPoints {
        private final boolean buildActuallyCancelled;

        public ExecutionCancelled(@NotNull ResultKey resultKey, @NotNull Date date, boolean buildActuallyCancelled) {
            super(resultKey, date);
            this.buildActuallyCancelled = buildActuallyCancelled;
        }

        public boolean isBuildActuallyCancelled() {
            return this.buildActuallyCancelled;
        }
    }

    public static class Queued
    extends DeploymentTimingPoints {
        Queued(@NotNull ResultKey resultKey, @NotNull Date date) {
            super(resultKey, date);
        }
    }

    public static class SentToAgent
    extends DeploymentTimingPoints {
        private final long agentId;

        SentToAgent(@NotNull ResultKey resultKey, @NotNull Date date, long agentId) {
            super(resultKey, date);
            this.agentId = agentId;
        }

        public long getAgentId() {
            return this.agentId;
        }
    }

    public static class AgentAssigned
    extends DeploymentTimingPoints {
        private final long agentId;

        AgentAssigned(@NotNull ResultKey resultKey, @NotNull Date date, long agentId) {
            super(resultKey, date);
            this.agentId = agentId;
        }

        public long getAgentId() {
            return this.agentId;
        }
    }

    public static class ExecutionStarted
    extends DeploymentTimingPoints {
        ExecutionStarted(@NotNull ResultKey resultKey, @NotNull Date date) {
            super(resultKey, date);
        }
    }

    public static class ExecutionFinished
    extends DeploymentTimingPoints {
        ExecutionFinished(@NotNull ResultKey resultKey, @NotNull Date date) {
            super(resultKey, date);
        }
    }
}

