/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.projects;

import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectItem;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.deployments.versions.DeploymentVersion;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentProjectFunctions {
    private static final Logger log = Logger.getLogger(DeploymentProjectFunctions.class);

    public static Function<DeploymentProject, List<DeploymentProjectItem>> getDeploymentProjectItems(@NotNull DeploymentProjectService deploymentProjectService) {
        return new GetDeploymentProjectItems(deploymentProjectService);
    }

    @Deprecated
    public static Function<DeploymentResult, DeploymentVersion> getDeploymentResultVersion() {
        return DeploymentResult::getDeploymentVersion;
    }

    private static class GetDeploymentProjectItems
    implements Function<DeploymentProject, List<DeploymentProjectItem>> {
        private final DeploymentProjectService deploymentProjectService;

        private GetDeploymentProjectItems(DeploymentProjectService deploymentProjectService) {
            this.deploymentProjectService = deploymentProjectService;
        }

        @Override
        public List<DeploymentProjectItem> apply(@Nullable DeploymentProject deploymentProject) {
            return this.deploymentProjectService.getDeploymentProjectItems(((DeploymentProject)Preconditions.checkNotNull((Object)deploymentProject)).getId());
        }
    }
}

