/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.projects.persistence;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.deployments.DeploymentKey;
import com.atlassian.bamboo.deployments.environments.persistence.MutableEnvironment;
import com.atlassian.bamboo.deployments.projects.persistence.MutableDeploymentProject;
import com.atlassian.bamboo.deployments.projects.persistence.items.MutableDeploymentProjectItem;
import com.atlassian.bamboo.deployments.projects.persistence.versionnaming.MutableVersionNamingScheme;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.utils.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface DeploymentProjectDao {
    public long countAllDeploymentProjects();

    @NotNull
    public List<MutableDeploymentProject> getAllDeploymentProjects();

    @NotNull
    public List<MutableDeploymentProject> getAllDeploymentProjects(int var1, int var2);

    @NotNull
    public List<MutableDeploymentProject> getDeploymentProjectsRelatedToPlan(@NotNull PlanKey var1);

    @NotNull
    public List<MutableDeploymentProject> getDeploymentProjectsRelatedToPlans(@NotNull Set<PlanKey> var1);

    @NotNull
    public List<MutableDeploymentProject> findDeploymentProjectsRelatedToArtifact(long var1);

    @Nullable
    public MutableDeploymentProject getDeploymentProject(long var1);

    @Nullable
    public MutableDeploymentProject getDeploymentProject(@NotNull DeploymentKey var1);

    public void save(MutableDeploymentProject var1);

    public void delete(MutableDeploymentProject var1);

    @NotNull
    public List<MutableDeploymentProjectItem> getProjectItems(long var1);

    @Nullable
    public MutableDeploymentProjectItem getProjectItem(long var1);

    @Nullable
    public MutableDeploymentProjectItem getArtifactProjectItem(long var1, long var3);

    public boolean doesArtifactProjectItemExist(long var1, long var3);

    public void save(MutableDeploymentProjectItem var1);

    public void delete(MutableDeploymentProjectItem var1);

    public boolean isDeploymentProjectNameConflicting(@NotNull String var1);

    @Nullable
    public MutableDeploymentProject getDeploymentProjectForEnvironment(long var1);

    @Nullable
    public MutableDeploymentProject getDeploymentProjectForVersion(long var1);

    @Nullable
    public MutableVersionNamingScheme getVersionNamingSchemeForProject(long var1);

    public void save(MutableVersionNamingScheme var1);

    public void delete(MutableVersionNamingScheme var1);

    public List<MutableDeploymentProject> getDeploymentProjectsReferencingArtifact(long var1);

    public int getDeploymentProjectCount();

    @NotNull
    public BambooEntityOid getMaxDeploymentProjectOid(int var1);

    @Nullable
    public MutableDeploymentProject findDeploymentProjectByOid(BambooEntityOid var1);

    @Nullable
    public MutableDeploymentProject findDeploymentProjectByName(String var1);

    @NotNull
    public MutableDeploymentProject createNewDeploymentProjectInstance();

    @NotNull
    public MutableVersionNamingScheme createNewVersionNamingSchemeInstance();

    @NotNull
    public Collection<Long> findDeploymentProjectsInOtherStates(VcsLocationBambooSpecsState var1);

    @NotNull
    public Set<Long> findSpecsStateIdsReferencedByDeployments();

    @Deprecated
    public void removeAbstractProjectItems();

    @Deprecated
    public List<Pair<MutableDeploymentProject, MutableEnvironment>> getPaginatedDeploymentsWithEnvironments(int var1, int var2, String var3);

    public List<Pair<Long, Long>> getPaginatedDeploymentsWithEnvironmentsOnlyIds(int var1, int var2, String var3);

    public List<MutableDeploymentProject> findAllByIds(Collection<Long> var1);
}

