/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.io.BambooStreamBootstrapper;
import com.ctc.wstx.io.BranchingReaderSource;
import com.ctc.wstx.io.DefaultInputResolver;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.SystemId;
import com.ctc.wstx.sr.ReaderCreator;
import com.ctc.wstx.sr.ValidatingStreamReader;
import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;

public class BambooWstxInputFactory
extends WstxInputFactory {
    protected XMLStreamReader2 createSR(SystemId systemId, InputStream in, String enc, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        if (in == null) {
            throw new IllegalArgumentException("Null InputStream is not a valid argument");
        }
        ReaderConfig cfg = this.createPrivateConfig();
        if (enc == null || enc.length() == 0) {
            return this.createSR(cfg, systemId, BambooStreamBootstrapper.getInstance(null, systemId, in), forER, autoCloseInput);
        }
        Reader r = DefaultInputResolver.constructOptimizedReader((ReaderConfig)cfg, (InputStream)in, (boolean)false, (String)enc);
        return this.createSR(cfg, systemId, (InputBootstrapper)ReaderBootstrapper.getInstance(null, (SystemId)systemId, (Reader)r, (String)enc), forER, autoCloseInput);
    }

    public XMLStreamReader2 createSR(ReaderConfig cfg, String systemId, InputBootstrapper bs, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        URL src = cfg.getBaseURL();
        if (src == null && systemId != null && systemId.length() > 0) {
            try {
                src = URLUtil.urlFromSystemId((String)systemId);
            }
            catch (IOException ie) {
                throw new WstxIOException(ie);
            }
        }
        return this.doCreateSR(cfg, systemId, bs, src, forER, autoCloseInput);
    }

    private XMLStreamReader2 doCreateSR(ReaderConfig cfg, String systemId, InputBootstrapper bs, URL src, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        Reader r;
        if (!autoCloseInput) {
            autoCloseInput = cfg.willAutoCloseInput();
        }
        try {
            r = bs.bootstrapInput(cfg, true, 0);
            if (bs.declaredXml11()) {
                cfg.enableXml11(true);
            }
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
        BranchingReaderSource input = InputSourceFactory.constructDocumentSource((ReaderConfig)cfg, (InputBootstrapper)bs, null, (SystemId)SystemId.construct((String)systemId, (URL)src), (Reader)r, (boolean)autoCloseInput);
        return ValidatingStreamReader.createValidatingStreamReader((BranchingReaderSource)input, (ReaderCreator)this, (ReaderConfig)cfg, (InputBootstrapper)bs, (boolean)forER);
    }
}

