/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ValidationContext {
    @NotNull
    private final List<String> contextPath;

    public static ValidationContext empty() {
        return new ValidationContext(Collections.emptyList());
    }

    public static ValidationContext of(@NotNull String context) {
        return new ValidationContext(Collections.singletonList(context));
    }

    private ValidationContext(@NotNull List<String> initialList) {
        this.contextPath = new ArrayList<String>(initialList);
    }

    public ValidationContext with(@NotNull String context) {
        ArrayList<String> newContextPath = new ArrayList<String>(this.contextPath);
        newContextPath.add(context);
        return new ValidationContext(newContextPath);
    }

    public boolean isEmpty() {
        return this.contextPath.isEmpty();
    }

    public boolean contains(String element) {
        return this.contextPath.contains(element);
    }

    public String toString() {
        return this.contextPath.stream().reduce((s1, s2) -> s1 + " / " + s2).orElse("");
    }
}

