/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.credentials;

import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsScope;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public class SharedCredentialsIdentifier
extends EntityPropertiesBuilder<SharedCredentialsIdentifierProperties> {
    private String name;
    private BambooOidProperties oid;
    private SharedCredentialsScope scope = SharedCredentialsScope.GLOBAL;

    private SharedCredentialsIdentifier() throws PropertiesValidationException {
    }

    public SharedCredentialsIdentifier(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
    }

    public SharedCredentialsIdentifier(@NotNull BambooOid oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        this.oid = (BambooOidProperties)EntityPropertiesBuilders.build(oid);
    }

    public SharedCredentialsIdentifier name(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
        return this;
    }

    public SharedCredentialsIdentifier oid(@NotNull String oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        return this.oid(new BambooOid(oid));
    }

    public SharedCredentialsIdentifier oid(@NotNull BambooOid oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        this.oid = (BambooOidProperties)EntityPropertiesBuilders.build(oid);
        return this;
    }

    public SharedCredentialsIdentifier scope(@NotNull SharedCredentialsScope scope) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("scope", scope);
        this.scope = scope;
        return this;
    }

    @Override
    protected SharedCredentialsIdentifierProperties build() throws PropertiesValidationException {
        return new SharedCredentialsIdentifierProperties(this.name, this.oid, this.scope);
    }
}

