/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.util;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class CronExpressionCreationHelper {
    private CronExpressionCreationHelper() {
    }

    public static String scheduleEvery(int every, @NotNull TimeUnit at) {
        ImporterUtils.checkNotNull("at", at);
        ImporterUtils.checkPositive("every", every);
        switch (at) {
            case SECONDS: {
                return String.format("0/%d * * ? * *", every);
            }
            case MINUTES: {
                return String.format("0 0/%d * ? * *", every);
            }
            case HOURS: {
                return String.format("0 0 0/%d ? * *", every);
            }
        }
        throw new PropertiesValidationException(String.format("Don't know how to schedule: %s. Please use other methods or define cron expression manually", new Object[]{at}));
    }

    public static String scheduleOnceDaily(@NotNull LocalTime at) {
        ImporterUtils.checkNotNull("at", at);
        return String.format("0 %d %d ? * *", at.getMinute(), at.getHour());
    }

    public static String scheduleWeekly(@NotNull LocalTime at, DayOfWeek ... onDays) {
        ImporterUtils.checkNotNull("at", at);
        ImporterUtils.checkNotNull("on", onDays);
        ArrayList<DayOfWeek> daysOfWeek = new ArrayList<DayOfWeek>();
        Collections.addAll(daysOfWeek, onDays);
        return CronExpressionCreationHelper.scheduleWeekly(at, daysOfWeek);
    }

    public static String scheduleWeekly(@NotNull LocalTime at, @NotNull Collection<DayOfWeek> days) {
        ImporterUtils.checkNotNull("at", at);
        ImporterUtils.checkNotNull("days", days);
        StringBuilder daysExpression = new StringBuilder();
        Iterator<DayOfWeek> iterator = days.iterator();
        if (iterator.hasNext()) {
            daysExpression.append(CronExpressionCreationHelper.getCronDayOfWeekValue(iterator.next()));
            while (iterator.hasNext()) {
                daysExpression.append(",");
                daysExpression.append(CronExpressionCreationHelper.getCronDayOfWeekValue(iterator.next()));
            }
        }
        return String.format("0 %d %d ? * %s", at.getMinute(), at.getHour(), daysExpression.toString());
    }

    public static String scheduleMonthly(@NotNull LocalTime at, int dayOfMonth) {
        ImporterUtils.checkNotNull("at", at);
        return String.format("0 %d %d %d * ?", at.getMinute(), at.getHour(), dayOfMonth);
    }

    private static int getCronDayOfWeekValue(DayOfWeek value) {
        TemporalField sundayBaseWeekTemporal = WeekFields.of(DayOfWeek.SUNDAY, 7).dayOfWeek();
        return value.get(sundayBaseWeekTemporal);
    }
}

