/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.credentials;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentials;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.credentials.AnySharedCredentialsProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnySharedCredentials
extends SharedCredentials<AnySharedCredentials, AnySharedCredentialsProperties> {
    private final Map<String, Object> configuration = new LinkedHashMap<String, Object>();
    protected final AtlassianModuleProperties atlassianPlugin;

    public AnySharedCredentials(@NotNull String name, @NotNull AtlassianModule atlassianPlugin) throws PropertiesValidationException {
        this(name, (AtlassianModuleProperties)EntityPropertiesBuilders.build(ImporterUtils.checkNotNull("atlassianPlugin", atlassianPlugin)));
    }

    private AnySharedCredentials(String name, AtlassianModuleProperties atlassianPlugin) {
        super(name);
        this.atlassianPlugin = ImporterUtils.checkNotNull("atlassianPlugin", atlassianPlugin);
    }

    public AnySharedCredentials configuration(Map<String, Object> configuration) {
        this.configuration.putAll(configuration);
        return this;
    }

    @Override
    public AnySharedCredentials oid(@Nullable String oid) throws PropertiesValidationException {
        super.oid(oid);
        return this;
    }

    @Override
    public AnySharedCredentials oid(@Nullable BambooOid oid) throws PropertiesValidationException {
        super.oid(oid);
        return this;
    }

    @Override
    protected AnySharedCredentialsProperties build() {
        return new AnySharedCredentialsProperties(this.atlassianPlugin, this.name, this.oid, this.configuration, this.project);
    }
}

