/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.permission;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.permission.AnonymousUserPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.GroupPermission;
import com.atlassian.bamboo.specs.api.builders.permission.LoggedInUserPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.PermissionType;
import com.atlassian.bamboo.specs.api.builders.permission.UserPermission;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import java.util.LinkedHashMap;
import java.util.Map;

public class Permissions
extends EntityPropertiesBuilder<PermissionsProperties> {
    private Map<String, UserPermission> userPermissions = new LinkedHashMap<String, UserPermission>();
    private Map<String, GroupPermission> groupPermissions = new LinkedHashMap<String, GroupPermission>();
    private LoggedInUserPermissions loggedInUserPermissions = new LoggedInUserPermissions();
    private AnonymousUserPermissions anonymousUserPermissions = new AnonymousUserPermissions();

    public Permissions userPermissions(String user, PermissionType ... permissionTypes) {
        this.userPermissions.putIfAbsent(user, new UserPermission(user));
        this.userPermissions.get(user).permissions(permissionTypes);
        return this;
    }

    public Permissions groupPermissions(String group, PermissionType ... permissionTypes) {
        this.groupPermissions.putIfAbsent(group, new GroupPermission(group));
        this.groupPermissions.get(group).permissions(permissionTypes);
        return this;
    }

    public Permissions loggedInUserPermissions(PermissionType ... permissionTypes) {
        this.loggedInUserPermissions.permissions(permissionTypes);
        return this;
    }

    public Permissions anonymousUserPermissionView() {
        this.anonymousUserPermissions.view();
        return this;
    }

    @Override
    protected PermissionsProperties build() {
        return new PermissionsProperties(this.userPermissions.values(), this.groupPermissions.values(), this.loggedInUserPermissions, this.anonymousUserPermissions);
    }
}

