/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan.configuration;

import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.model.plan.configuration.ConcurrentBuildsProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ConcurrentBuilds
extends PluginConfiguration<ConcurrentBuildsProperties> {
    private boolean useSystemWideDefault = true;
    private int maximumNumberOfConcurrentBuilds = 1;
    private ConcurrentBuildsStrategy concurrentBuildsStrategy = ConcurrentBuildsStrategy.getDefault();

    public ConcurrentBuilds useSystemWideDefault(boolean useSystemWideDefault) {
        this.useSystemWideDefault = useSystemWideDefault;
        return this;
    }

    public ConcurrentBuilds maximumNumberOfConcurrentBuilds(int maximumNumberOfConcurrentBuilds) {
        ImporterUtils.checkThat(ValidationContext.of("maximumNumberOfConcurrentBuilds"), maximumNumberOfConcurrentBuilds > 0, "Maximum number of concurrent builds must be greater than 0.", new Object[0]);
        this.maximumNumberOfConcurrentBuilds = maximumNumberOfConcurrentBuilds;
        this.useSystemWideDefault(false);
        return this;
    }

    public ConcurrentBuilds concurrentBuildsStrategy(ConcurrentBuildsStrategy concurrentBuildsStrategy) {
        this.concurrentBuildsStrategy = concurrentBuildsStrategy;
        return this;
    }

    public ConcurrentBuilds blockTriggeringStrategy() {
        return this.concurrentBuildsStrategy(ConcurrentBuildsStrategy.BLOCK_TRIGGERING);
    }

    public ConcurrentBuilds stopOldestBuildsStrategy() {
        return this.concurrentBuildsStrategy(ConcurrentBuildsStrategy.STOP_OLDEST_BUILDS);
    }

    @Override
    @NotNull
    protected ConcurrentBuildsProperties build() {
        return new ConcurrentBuildsProperties(this.useSystemWideDefault, this.maximumNumberOfConcurrentBuilds, this.concurrentBuildsStrategy);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConcurrentBuilds)) {
            return false;
        }
        ConcurrentBuilds that = (ConcurrentBuilds)o;
        return this.useSystemWideDefault == that.useSystemWideDefault && this.maximumNumberOfConcurrentBuilds == that.maximumNumberOfConcurrentBuilds && this.concurrentBuildsStrategy == that.concurrentBuildsStrategy;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.useSystemWideDefault, this.maximumNumberOfConcurrentBuilds, this.concurrentBuildsStrategy});
    }

    public static enum ConcurrentBuildsStrategy {
        BLOCK_TRIGGERING,
        STOP_OLDEST_BUILDS;


        public static ConcurrentBuildsStrategy getDefault() {
            return BLOCK_TRIGGERING;
        }
    }
}

