/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.repository;

import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public class VcsRepositoryIdentifier
extends EntityPropertiesBuilder<VcsRepositoryIdentifierProperties> {
    private String name;
    private BambooOidProperties oid;

    public VcsRepositoryIdentifier() throws PropertiesValidationException {
    }

    public VcsRepositoryIdentifier(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
    }

    public VcsRepositoryIdentifier(@NotNull BambooOid oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        this.oid = (BambooOidProperties)EntityPropertiesBuilders.build(oid);
    }

    public VcsRepositoryIdentifier name(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
        return this;
    }

    public VcsRepositoryIdentifier oid(@NotNull String oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        return this.oid(new BambooOid(oid));
    }

    public VcsRepositoryIdentifier oid(@NotNull BambooOid oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        this.oid = (BambooOidProperties)EntityPropertiesBuilders.build(oid);
        return this;
    }

    @Override
    protected VcsRepositoryIdentifierProperties build() throws PropertiesValidationException {
        return new VcsRepositoryIdentifierProperties(this.name, this.oid);
    }
}

