/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.dependencies;

import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.DependenciesConfigurationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DependenciesProperties
implements EntityProperties {
    private final DependenciesConfigurationProperties dependenciesConfigurationProperties;
    private final List<PlanIdentifierProperties> childPlans;

    protected DependenciesProperties() {
        this.dependenciesConfigurationProperties = new DependenciesConfigurationProperties();
        this.childPlans = new ArrayList<PlanIdentifierProperties>();
    }

    public DependenciesProperties(DependenciesConfigurationProperties dependenciesConfigurationProperties, List<PlanIdentifierProperties> childPlans) {
        this.dependenciesConfigurationProperties = dependenciesConfigurationProperties;
        this.childPlans = Collections.unmodifiableList(new ArrayList<PlanIdentifierProperties>(childPlans));
        this.validate();
    }

    public DependenciesConfigurationProperties getDependenciesConfigurationProperties() {
        return this.dependenciesConfigurationProperties;
    }

    public List<PlanIdentifierProperties> getChildPlans() {
        return this.childPlans;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependenciesProperties that = (DependenciesProperties)o;
        return Objects.equals(this.dependenciesConfigurationProperties, that.dependenciesConfigurationProperties) && Objects.equals(this.childPlans, that.childPlans);
    }

    public int hashCode() {
        return Objects.hash(this.dependenciesConfigurationProperties, this.childPlans);
    }

    @Override
    public void validate() {
        ImporterUtils.checkNotNull("dependenciesConfigurationProperties", this.dependenciesConfigurationProperties);
        ImporterUtils.checkNotNull("childPlans", this.childPlans);
    }
}

