/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.plan;

import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactProperties;
import com.atlassian.bamboo.specs.api.validators.VariableValidator;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class PlanValidator {
    private PlanValidator() {
    }

    @NotNull
    public static List<ValidationProblem> validate(@NotNull PlanProperties planProperties) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        errors.addAll(PlanValidator.validateUniqueStageNames(planProperties.getStages()));
        errors.addAll(PlanValidator.validateUniqueJobKeysAndNames(planProperties.getStages()));
        errors.addAll(VariableValidator.validateUniqueVariableNames(planProperties.getVariables()));
        errors.addAll(PlanValidator.validateArtifactsAndSubscriptions(planProperties.getStages()));
        return errors;
    }

    private static Collection<? extends ValidationProblem> validateUniqueJobKeysAndNames(List<StageProperties> stages) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        HashSet<String> jobNames = new HashSet<String>();
        HashSet<BambooKeyProperties> jobKeys = new HashSet<BambooKeyProperties>();
        for (StageProperties stage : stages) {
            for (JobProperties job : stage.getJobs()) {
                if (jobNames.contains(job.getName())) {
                    errors.add(new ValidationProblem("Duplicate job name " + job.getName()));
                }
                if (job.getKey() != null && jobKeys.contains(job.getKey())) {
                    errors.add(new ValidationProblem("Duplicate job key " + job.getKey().getKey()));
                }
                jobNames.add(job.getName());
                jobKeys.add(job.getKey());
            }
        }
        return errors;
    }

    private static Collection<? extends ValidationProblem> validateUniqueStageNames(List<StageProperties> stages) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        HashSet<String> stageNames = new HashSet<String>();
        for (StageProperties stage : stages) {
            if (stageNames.contains(stage.getName())) {
                errors.add(new ValidationProblem("Duplicate stage name " + stage.getName()));
            }
            stageNames.add(stage.getName());
        }
        return errors;
    }

    @NotNull
    private static List<ValidationProblem> validateArtifactsAndSubscriptions(@NotNull List<StageProperties> stages) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        HashMap existingArtifacts = new HashMap();
        HashSet allSharedArtifactNames = new HashSet();
        for (StageProperties stage : stages) {
            stage.getJobs().forEach(job -> job.getArtifactSubscriptions().forEach(subscription -> {
                if (StringUtils.isBlank((CharSequence)subscription.getArtifactName())) {
                    errors.add(new ValidationProblem(String.format("Artifact name undefined in job %s", job.getName())));
                } else if (!existingArtifacts.containsKey(subscription.getArtifactName())) {
                    errors.add(new ValidationProblem(String.format("Artifact %s subscribed in job %s not defined", subscription.getArtifactName(), job.getName())));
                } else if (!((ArtifactProperties)existingArtifacts.get(subscription.getArtifactName())).isShared()) {
                    errors.add(new ValidationProblem(String.format("Artifact %s subscribed in job %s is not a shared artifact", subscription.getArtifactName(), job.getName())));
                }
            }));
            for (JobProperties job2 : stage.getJobs()) {
                HashSet jobArtifactNames = new HashSet();
                job2.getArtifacts().forEach(artifact -> {
                    if (artifact.isShared()) {
                        if (allSharedArtifactNames.contains(artifact.getName())) {
                            errors.add(new ValidationProblem(String.format("Duplicate shared artifact name %s", artifact.getName())));
                        }
                        allSharedArtifactNames.add(artifact.getName());
                    }
                    if (jobArtifactNames.contains(artifact.getName())) {
                        errors.add(new ValidationProblem(String.format("Duplicate artifact name %s in job %s", artifact.getName(), job2.getName())));
                    }
                    jobArtifactNames.add(artifact.getName());
                    existingArtifacts.put(artifact.getName(), artifact);
                });
            }
        }
        return errors;
    }
}

