/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.project;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Project
extends EntityPropertiesBuilder<ProjectProperties> {
    private BambooKeyProperties key;
    private BambooOidProperties oid;
    private String name;
    private String description;

    public Project name(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("name", name);
        this.name = name;
        return this;
    }

    public Project key(@Nullable String key) throws PropertiesValidationException {
        return this.key(key != null ? new BambooKey(key) : null);
    }

    public Project key(@Nullable BambooKey key) throws PropertiesValidationException {
        this.key = key != null ? (BambooKeyProperties)EntityPropertiesBuilders.build(key) : null;
        return this;
    }

    public Project description(@Nullable String description) throws PropertiesValidationException {
        this.description = description;
        return this;
    }

    public Project oid(@Nullable String oid) throws PropertiesValidationException {
        return this.oid(oid != null ? new BambooOid(oid) : null);
    }

    public Project oid(@Nullable BambooOid oid) throws PropertiesValidationException {
        this.oid = oid != null ? (BambooOidProperties)EntityPropertiesBuilders.build(oid) : null;
        return this;
    }

    @Override
    protected ProjectProperties build() throws PropertiesValidationException {
        return new ProjectProperties(this.oid, this.key, this.name, this.description);
    }
}

