/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.applink;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ApplicationLinkProperties
implements EntityProperties {
    private final String name;
    private final String id;

    private ApplicationLinkProperties() {
        this.name = null;
        this.id = null;
    }

    public ApplicationLinkProperties(@Nullable String name, @Nullable String id) {
        this.name = name;
        this.id = id;
        this.validate();
    }

    public boolean isNameDefined() {
        return StringUtils.isNotBlank((CharSequence)this.name);
    }

    public boolean isIdDefined() {
        return StringUtils.isNotBlank((CharSequence)this.id);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationLinkProperties that = (ApplicationLinkProperties)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getId());
    }

    public String toString() {
        return "ApplicationLinkProperties{name='" + this.name + '\'' + ", id='" + this.id + '\'' + '}';
    }

    @Override
    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.name) && StringUtils.isBlank((CharSequence)this.id)) {
            throw new PropertiesValidationException("Either application name or id need to be defined when referencing an external application");
        }
    }
}

