/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.repository;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.repository.VcsRepositoryValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class AnyVcsRepositoryProperties
extends VcsRepositoryProperties {
    private AtlassianModuleProperties atlassianPlugin;
    private Map<String, Object> serverConfiguration;
    private Map<String, Object> branchConfiguration;
    private Map<String, Object> branchDetectionConfiguration;
    private VcsChangeDetectionProperties changeDetectionConfiguration;

    private AnyVcsRepositoryProperties() {
    }

    public AnyVcsRepositoryProperties(AtlassianModuleProperties atlassianPlugin, @Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable Map<String, Object> serverConfiguration, @Nullable Map<String, Object> branchConfiguration, @Nullable VcsChangeDetectionProperties changeDetectionConfiguration, @Nullable Map<String, Object> branchDetectionConfiguration, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties) throws PropertiesValidationException {
        super(name, oid, description, parent, repositoryViewerProperties);
        this.atlassianPlugin = atlassianPlugin;
        this.serverConfiguration = serverConfiguration != null ? Collections.unmodifiableMap(new HashMap<String, Object>(serverConfiguration)) : null;
        this.branchConfiguration = branchConfiguration != null ? Collections.unmodifiableMap(new HashMap<String, Object>(branchConfiguration)) : null;
        this.changeDetectionConfiguration = changeDetectionConfiguration;
        this.branchDetectionConfiguration = branchDetectionConfiguration != null ? Collections.unmodifiableMap(new HashMap<String, Object>(branchDetectionConfiguration)) : null;
        this.validate();
    }

    @Override
    @Nullable
    public AtlassianModuleProperties getAtlassianPlugin() {
        return this.atlassianPlugin;
    }

    @Nullable
    public Map<String, Object> getServerConfiguration() {
        return this.serverConfiguration;
    }

    @Nullable
    public Map<String, Object> getBranchConfiguration() {
        return this.branchConfiguration;
    }

    @Nullable
    public VcsChangeDetectionProperties getChangeDetectionConfiguration() {
        return this.changeDetectionConfiguration;
    }

    @Nullable
    public Map<String, Object> getBranchDetectionConfiguration() {
        return this.branchDetectionConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnyVcsRepositoryProperties that = (AnyVcsRepositoryProperties)o;
        return Objects.equals(this.getAtlassianPlugin(), that.getAtlassianPlugin()) && Objects.equals(this.getServerConfiguration(), that.getServerConfiguration()) && Objects.equals(this.getBranchConfiguration(), that.getBranchConfiguration()) && Objects.equals(this.getBranchDetectionConfiguration(), that.getBranchDetectionConfiguration()) && Objects.equals(this.getChangeDetectionConfiguration(), that.getChangeDetectionConfiguration());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAtlassianPlugin(), this.getServerConfiguration(), this.getBranchConfiguration(), this.getBranchDetectionConfiguration(), this.getChangeDetectionConfiguration());
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getParentName() == null) {
            ImporterUtils.checkNotNull("atlassianPlugin", this.atlassianPlugin);
        }
        ImporterUtils.checkNoErrors(VcsRepositoryValidator.validate(this));
    }
}

