/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.deployment;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.model.deployment.ReleaseNamingProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ReleaseNaming
extends EntityPropertiesBuilder<ReleaseNamingProperties> {
    private String nextVersionName;
    private boolean autoIncrement;
    private boolean applicableToBranches;
    private Set<String> variablesToAutoIncrement = new HashSet<String>();

    public ReleaseNaming(@NotNull String nextVersionName) {
        ImporterUtils.checkNotBlank("nextVersionName", nextVersionName);
        this.nextVersionName = nextVersionName;
    }

    public ReleaseNaming autoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
        return this;
    }

    public ReleaseNaming applicableToBranches(boolean applicableToBranches) {
        this.applicableToBranches = applicableToBranches;
        return this;
    }

    public ReleaseNaming variablesToAutoIncrement(String ... variablesToAutoIncrement) {
        ImporterUtils.checkNotNull("variablesToAutoIncrement", variablesToAutoIncrement);
        this.variablesToAutoIncrement.addAll(Arrays.asList(variablesToAutoIncrement));
        return this;
    }

    @Override
    protected ReleaseNamingProperties build() {
        return new ReleaseNamingProperties(this.nextVersionName, this.autoIncrement, this.applicableToBranches, this.variablesToAutoIncrement);
    }
}

