/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.context;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RssRuntimeContext {
    private static final String CURRENT_BRANCH_PROPERTY_NAME = "rss.current.branch";
    private static final String IS_DEFAULT_BRANCH_PROPERTY_NAME = "rss.default.branch";
    private static final String SERVER_NAME_PROPERTY_NAME = "specs.bamboo.instanceName";
    private static String currentBranch;
    private static Boolean isDefaultBranch;
    private static String serverName;

    @NotNull
    public static Optional<String> getCurrentRssBranch() {
        return Optional.ofNullable(currentBranch);
    }

    @NotNull
    public static Optional<Boolean> isDefaultRssBranch() {
        return Optional.ofNullable(isDefaultBranch);
    }

    @NotNull
    public static Optional<String> getServerName() {
        return Optional.ofNullable(serverName);
    }

    private static void loadProperties() {
        currentBranch = RssRuntimeContext.readProperty(CURRENT_BRANCH_PROPERTY_NAME);
        String isDefaultBranch = System.getProperty(IS_DEFAULT_BRANCH_PROPERTY_NAME);
        if (isDefaultBranch != null) {
            RssRuntimeContext.isDefaultBranch = Boolean.valueOf(isDefaultBranch);
        }
        serverName = RssRuntimeContext.readProperty(SERVER_NAME_PROPERTY_NAME);
    }

    @Nullable
    private static String readProperty(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            try {
                return new String(Base64.getDecoder().decode(propertyValue.getBytes(StandardCharsets.ISO_8859_1)), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                return propertyValue;
            }
        }
        return null;
    }

    private RssRuntimeContext() {
    }

    static {
        RssRuntimeContext.loadProperties();
    }
}

