/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.notification;

import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationTypeProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class NotificationProperties
implements EntityProperties {
    private final NotificationTypeProperties type;
    private final List<NotificationRecipientProperties> recipients;

    protected NotificationProperties() {
        this.type = null;
        this.recipients = Collections.emptyList();
    }

    public NotificationProperties(NotificationTypeProperties type, List<NotificationRecipientProperties> recipients) {
        this.type = type;
        this.recipients = recipients;
        this.validate();
    }

    public NotificationTypeProperties getType() {
        return this.type;
    }

    public List<NotificationRecipientProperties> getRecipients() {
        return this.recipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationProperties that = (NotificationProperties)o;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getRecipients(), that.getRecipients());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getRecipients());
    }

    @Override
    public void validate() {
        ValidationContext context = ValidationContext.of("Notification");
        ImporterUtils.checkNotNull(context.with("type"), "type", this.type);
        ImporterUtils.checkThat(context.with("recipients"), this.recipients != null && !this.recipients.isEmpty(), "Recipients of the notification not defined", this.recipients);
    }
}

