/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.permission;

import com.atlassian.bamboo.specs.api.builders.permission.PermissionType;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public class LoggedInUserPermissionsProperties
implements EntityProperties {
    private final Set<PermissionType> permissionTypes;

    private LoggedInUserPermissionsProperties() {
        this.permissionTypes = null;
    }

    public LoggedInUserPermissionsProperties(@NotNull Collection<PermissionType> permissionTypes) throws PropertiesValidationException {
        this.permissionTypes = Collections.unmodifiableSet(new LinkedHashSet<PermissionType>(permissionTypes));
        this.validate();
    }

    public Set<PermissionType> getPermissionTypes() {
        return this.permissionTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggedInUserPermissionsProperties that = (LoggedInUserPermissionsProperties)o;
        return Objects.equals(this.permissionTypes, that.permissionTypes);
    }

    public int hashCode() {
        return Objects.hash(this.permissionTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LoggedInUserPermissionsProperties{");
        sb.append("permissionTypes=").append(this.permissionTypes);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void validate() throws PropertiesValidationException {
    }
}

