/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.repository;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.Nullable;

public class VcsRepositoryIdentifierProperties
implements EntityProperties {
    private final BambooOidProperties oid;
    private final String name;

    public VcsRepositoryIdentifierProperties(@Nullable String name, @Nullable BambooOidProperties oid) throws PropertiesValidationException {
        this.name = name;
        this.oid = oid;
        this.validate();
    }

    private VcsRepositoryIdentifierProperties() {
        this.name = null;
        this.oid = null;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isNameDefined() {
        return StringUtils.isNotBlank((CharSequence)this.name);
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    public boolean isOidDefined() {
        return this.oid != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRepositoryIdentifierProperties that = (VcsRepositoryIdentifierProperties)o;
        return Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getOid(), this.getName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("oid", (Object)this.oid).append("name", (Object)this.name).build();
    }

    @Override
    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.name) && this.oid == null) {
            throw new PropertiesValidationException("Either name or oid need to be defined when referencing a repository");
        }
    }
}

