/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.permission;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.permission.Permissions;
import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.RootEntityProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.permission.PermissionValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@ConstructFrom(value={"projectKey"})
public class ProjectPermissionsProperties
implements RootEntityProperties {
    private final BambooKeyProperties projectKey;
    private final PermissionsProperties projectPermissions;
    private final PermissionsProperties projectPlanPermissions;
    private final List<VcsRepositoryIdentifierProperties> specsRepositories;

    private ProjectPermissionsProperties() {
        this.projectKey = null;
        this.projectPermissions = null;
        this.projectPlanPermissions = null;
        this.specsRepositories = Collections.emptyList();
    }

    public ProjectPermissionsProperties(@NotNull BambooKey projectKey, @NotNull Permissions projectPermissions, @NotNull Permissions projectPlanPermissions, @NotNull List<VcsRepositoryIdentifierProperties> specsRepositories) throws PropertiesValidationException {
        this.projectKey = (BambooKeyProperties)EntityPropertiesBuilders.build(projectKey);
        this.projectPermissions = (PermissionsProperties)EntityPropertiesBuilders.build(projectPermissions);
        this.projectPlanPermissions = (PermissionsProperties)EntityPropertiesBuilders.build(projectPlanPermissions);
        this.specsRepositories = Collections.unmodifiableList(new ArrayList<VcsRepositoryIdentifierProperties>(specsRepositories));
        this.validate();
    }

    @Override
    public void validate() {
        ImporterUtils.checkNotNull("projectKey", this.projectKey);
        ImporterUtils.checkNotNull("projectPermissions", this.projectPermissions);
        ImporterUtils.checkNotNull("projectPlanPermissions", this.projectPlanPermissions);
        ImporterUtils.checkNoErrors(PermissionValidator.validatePermissions(this.projectPermissions, PermissionValidator.PermissionTarget.PROJECT));
        ImporterUtils.checkNoErrors(PermissionValidator.validatePermissions(this.projectPlanPermissions, PermissionValidator.PermissionTarget.PLAN));
    }

    public BambooKeyProperties getProjectKey() {
        return this.projectKey;
    }

    public PermissionsProperties getProjectPermissions() {
        return this.projectPermissions;
    }

    public PermissionsProperties getProjectPlanPermissions() {
        return this.projectPlanPermissions;
    }

    @NotNull
    public List<VcsRepositoryIdentifierProperties> getSpecsRepositories() {
        return this.specsRepositories != null ? this.specsRepositories : Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPermissionsProperties that = (ProjectPermissionsProperties)o;
        return Objects.equals(this.getProjectKey(), that.getProjectKey()) && Objects.equals(this.getProjectPermissions(), that.getProjectPermissions()) && Objects.equals(this.getProjectPlanPermissions(), that.getProjectPlanPermissions()) && Objects.equals(this.getSpecsRepositories(), that.getSpecsRepositories());
    }

    public int hashCode() {
        return Objects.hash(this.getProjectKey(), this.getProjectPermissions(), this.getProjectPlanPermissions());
    }

    @Override
    @NotNull
    public String humanReadableType() {
        return "project permissions";
    }

    @Override
    @NotNull
    public String humanReadableId() {
        return String.format("%s for project %s", "project permissions", this.projectKey);
    }
}

