/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.crypto.AtlassianRandom;
import com.atlassian.bamboo.plugins.ssh.SshBuilderHelper;
import com.atlassian.bamboo.plugins.ssh.SshClientAndServerFactory;
import com.atlassian.bamboo.utils.SystemProperty;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;

public class AtlassianSshClientAndServerFactory
implements SshClientAndServerFactory {
    public static final AtlassianSshClientAndServerFactory INSTANCE = new AtlassianSshClientAndServerFactory();
    private final Factory<Random> atlassianRandomFactory = new SingletonRandomFactory((NamedFactory)new AtlassianRandom.Factory());
    private final ClientBuilder sshClientBuilder = (ClientBuilder)SshBuilderHelper.newClientBuilder().hostConfigEntryResolver(HostConfigEntryResolver.EMPTY).randomFactory(this.atlassianRandomFactory);
    private final ServerBuilder sshServerBuilder = (ServerBuilder)SshBuilderHelper.newServerBuilder().randomFactory(this.atlassianRandomFactory);
    private final long authTimeout;
    private final long idleTimeout;

    public AtlassianSshClientAndServerFactory() {
        this(SystemProperty.SSH_PROXY_CLIENT_AUTH_TIMEOUT.getTypedValue(), TimeUnit.MINUTES, SystemProperty.SSH_PROXY_CLIENT_IDLE_TIMEOUT.getTypedValue(), TimeUnit.MINUTES);
    }

    public AtlassianSshClientAndServerFactory(long authTimeout, TimeUnit authTimeoutUnit, long idleTimeout, TimeUnit idleTimeoutUnit) {
        this.authTimeout = authTimeoutUnit.toMillis(authTimeout);
        this.idleTimeout = idleTimeoutUnit.toMillis(idleTimeout);
    }

    @Override
    public SshClient createSshClient() {
        SshClient sshClient = (SshClient)this.sshClientBuilder.build();
        PropertyResolverUtils.updateProperty((PropertyResolver)sshClient, (String)CoreModuleProperties.AUTH_TIMEOUT.getName(), (long)this.authTimeout);
        PropertyResolverUtils.updateProperty((PropertyResolver)sshClient, (String)CoreModuleProperties.IDLE_TIMEOUT.getName(), (long)this.idleTimeout);
        return sshClient;
    }

    @Override
    public SshServer createSshServer() {
        return (SshServer)this.sshServerBuilder.build();
    }
}

