/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.crypto.BouncyCastleProviderUtils;
import com.atlassian.security.random.SecureRandomFactory;
import com.google.common.base.Stopwatch;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.jetbrains.annotations.NotNull;

public class OneKeyPairProvider
extends AbstractKeyPairProvider {
    private static final Logger logger = LogManager.getLogger(OneKeyPairProvider.class);
    private static final int KEY_SIZE = 2048;
    private static final String KEY_ALGORITHM_NAME = "RSA";
    private final KeyPairGenerator keyPairGenerator = this.getKeyPairGenerator();
    private final KeyPair keyPair = this.getKeyPair();

    public Iterable<KeyPair> loadKeys(SessionContext session) {
        return Collections.singleton(this.keyPair);
    }

    @NotNull
    private KeyPairGenerator getKeyPairGenerator() {
        KeyPairGenerator gen;
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Initializing new KeyPair Generator");
        try {
            gen = KeyPairGenerator.getInstance(KEY_ALGORITHM_NAME, BouncyCastleProviderUtils.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        gen.initialize(2048, SecureRandomFactory.newInstance());
        logger.debug("KeyPair Generator initialized in {}", (Object)stopwatch);
        return gen;
    }

    private KeyPair getKeyPair() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Initializing new key pair");
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        logger.debug("New key pair generated in {}", (Object)stopwatch);
        return keyPair;
    }
}

