/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.crypto.BouncyCastleProviderUtils;
import com.atlassian.bamboo.crypto.SshKeyUtils;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataBuilder;
import com.atlassian.bamboo.ssh.ProxyErrorReceiver;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.Lazy;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PEMParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyConnectionDataBuilderImpl
implements ProxyConnectionDataBuilder {
    private static final Logger log = Logger.getLogger(ProxyConnectionDataBuilderImpl.class);
    private String remoteUserName;
    private KeyPair keyPair;
    private ProxyErrorReceiver proxyErrorReceiver;
    private String remotePassword;
    private String mapPathFrom;
    private String mapPathTo;
    private String connectionDescription;
    private String host;
    private Integer port;

    public ProxyConnectionDataBuilderImpl withRemoteUserName(String name) {
        this.remoteUserName = name;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withKeyFromFile(@NotNull String filePath, @Nullable String passphrase) {
        this.keyPair = SshKeyUtils.loadKeyFromFile((String)filePath, (String)passphrase);
        return this;
    }

    public ProxyConnectionDataBuilderImpl withKeyFromString(String key, @Nullable String passphrase) {
        this.keyPair = SshKeyUtils.loadKeyFromString((String)key, (String)passphrase);
        return this;
    }

    public ProxyConnectionDataBuilderImpl withRemotePathMapping(@NotNull String from, @NotNull String to) {
        this.mapPathFrom = from;
        this.mapPathTo = to;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withConnectionDescription(@Nullable String connectionDescription) {
        this.connectionDescription = connectionDescription;
        return this;
    }

    @Deprecated
    public ProxyConnectionDataBuilderImpl withKeyFromReader(@NotNull Reader keyReader, @Nullable String passphrase) throws IOException {
        try (PEMParser pemParser = new PEMParser(keyReader);){
            Object pemKeyPair = pemParser.readObject();
            Preconditions.checkArgument((pemKeyPair != null ? 1 : 0) != 0, (Object)"Cannot read keypair, it doesn't contain any line with '-----BEGIN'");
            this.keyPair = BouncyCastleProviderUtils.toJavaKeyPair((Object)pemKeyPair, (String)passphrase);
        }
        return this;
    }

    public ProxyConnectionDataBuilderImpl withKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withRemoteHost(@Nullable String host) {
        this.host = host;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withRemotePort(@Nullable Integer port) {
        this.port = port;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withErrorReceiver(ProxyErrorReceiver receiver) {
        this.proxyErrorReceiver = receiver;
        return this;
    }

    public ProxyConnectionDataBuilderImpl withRemotePassword(String password) {
        this.remotePassword = password;
        return this;
    }

    public ProxyConnectionData build() {
        return new ProxyConnectionData(){
            private final Supplier<SocketAddress> remoteAddress = Lazy.supplier(() -> new InetSocketAddress(ProxyConnectionDataBuilderImpl.this.host, (int)ProxyConnectionDataBuilderImpl.this.port));

            public String getMapPathFrom() {
                return ProxyConnectionDataBuilderImpl.this.mapPathFrom;
            }

            public String getMapPathTo() {
                return ProxyConnectionDataBuilderImpl.this.mapPathTo;
            }

            public SocketAddress getRemoteAddress() {
                return this.remoteAddress.get();
            }

            public Integer getRemotePort() {
                return ProxyConnectionDataBuilderImpl.this.port;
            }

            public String getRemoteHost() {
                return ProxyConnectionDataBuilderImpl.this.host;
            }

            public String getRemoteUserName() {
                return ProxyConnectionDataBuilderImpl.this.remoteUserName;
            }

            public KeyPair getKeyPair() {
                return ProxyConnectionDataBuilderImpl.this.keyPair;
            }

            public String getConnectionDescription() {
                return ProxyConnectionDataBuilderImpl.this.connectionDescription;
            }

            public String getRemotePassword() {
                return ProxyConnectionDataBuilderImpl.this.remotePassword;
            }

            public void reportProxyError(String message, Throwable exception) {
                if (ProxyConnectionDataBuilderImpl.this.proxyErrorReceiver != null) {
                    ProxyConnectionDataBuilderImpl.this.proxyErrorReceiver.reportProxyError(message, exception);
                }
            }

            public ProxyErrorReceiver getErrorReceiver() {
                return ProxyConnectionDataBuilderImpl.this.proxyErrorReceiver;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("[").append(this.getRemoteUserName()).append("@").append(this.getRemoteAddress()).append("]");
                if (this.getConnectionDescription() != null) {
                    sb.append(" '").append(this.getConnectionDescription()).append("'");
                }
                return sb.toString();
            }
        };
    }

    public ProxyConnectionDataBuilder withProxyConnectionData(ProxyConnectionData connectionData) {
        this.withRemoteHost(connectionData.getRemoteHost()).withRemotePort(connectionData.getRemotePort()).withRemoteUserName(connectionData.getRemoteUserName()).withKeyPair(connectionData.getKeyPair()).withRemotePassword(connectionData.getRemotePassword()).withConnectionDescription(connectionData.getConnectionDescription()).withErrorReceiver(connectionData.getErrorReceiver());
        if (connectionData.getMapPathFrom() != null && connectionData.getMapPathTo() != null) {
            this.withRemotePathMapping(connectionData.getMapPathFrom(), connectionData.getMapPathTo());
        }
        return this;
    }
}

