/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.ProxyConnectionDataBuilderImpl;
import com.atlassian.bamboo.plugins.ssh.ProxyRegistrationInfoImpl;
import com.atlassian.bamboo.plugins.ssh.SshProxy;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataBuilder;
import com.atlassian.bamboo.ssh.ProxyException;
import com.atlassian.bamboo.ssh.ProxyRegistrationInfo;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.bamboo.utils.i18n.DocumentationLinkProvider;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class SshProxyServiceImpl
implements SshProxyService {
    private static final Logger log = Logger.getLogger(SshProxyServiceImpl.class);
    private final DocumentationLinkProvider documentationLinkProvider;

    @Autowired
    public SshProxyServiceImpl(DocumentationLinkProvider documentationLinkProvider) {
        this.documentationLinkProvider = documentationLinkProvider;
    }

    public ProxyRegistrationInfo register(@NotNull ProxyConnectionData connectionData) throws ProxyException {
        SshProxy sshProxy = SshProxy.getRunningInstance();
        if (sshProxy == null) {
            throw new ProxyException("Cannot start SshProxy");
        }
        if (sshProxy.getClientInitializationException() != null) {
            throw new ProxyException("SshProxy failed to initialize client properly. Is your remote agent updated?", (Throwable)sshProxy.getClientInitializationException());
        }
        String proxyUserName = UUID.randomUUID().toString();
        sshProxy.add(proxyUserName, connectionData);
        return new ProxyRegistrationInfoImpl(sshProxy.getHost(), sshProxy.getPort(), connectionData, proxyUserName);
    }

    public void unregister(@Nullable ProxyRegistrationInfo registrationInfo) {
        SshProxy sshProxy;
        if (registrationInfo != null && (sshProxy = SshProxy.getRunningInstance()) != null) {
            sshProxy.remove(registrationInfo.getProxyUserName());
        }
    }

    @NotNull
    public ProxyConnectionDataBuilder createProxyConnectionDataBuilder() {
        return new ProxyConnectionDataBuilderImpl();
    }
}

