/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.core;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.core.ClusterLockStatus;
import com.atlassian.beehive.core.ManagedClusterLock;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class LockRegistry<T extends ManagedClusterLock> {
    private final ConcurrentMap<String, T> lockMap = new ConcurrentHashMap<String, T>();

    public Collection<T> getAllKnownClusterLocks() {
        return ImmutableList.copyOf(this.lockMap.values());
    }

    public Collection<ClusterLockStatus> getStatusesOfAllHeldClusterLocks() {
        return ImmutableList.copyOf((Collection)this.lockMap.values().stream().filter(ManagedClusterLock::isLocked).map(ManagedClusterLock::getClusterLockStatus).collect(Collectors.toList()));
    }

    public ClusterLock getLockForName(@Nonnull String lockName) {
        ManagedClusterLock lock = (ManagedClusterLock)this.lockMap.get(lockName);
        if (lock != null) {
            return lock;
        }
        lock = this.createLock(lockName);
        ManagedClusterLock sneak = this.lockMap.putIfAbsent(lockName, lock);
        return sneak != null ? sneak : lock;
    }

    protected abstract T createLock(String var1);
}

