/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.db;

import com.atlassian.beehive.core.stats.StatisticsKey;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class StatisticsHolder {
    private final AtomicLong lastStateChangeAt = new AtomicLong();
    private final AtomicLong failLocal = new AtomicLong();
    private final AtomicLong failRemote = new AtomicLong();
    private final AtomicLong forcedUnlock = new AtomicLong();
    private final AtomicLong lock = new AtomicLong();
    private final AtomicLong unlock = new AtomicLong();
    private final AtomicLong totalHoldTimeMillis = new AtomicLong();
    private final AtomicLong totalWaitTimeMillis = new AtomicLong();
    private final AtomicLong totalWaits = new AtomicLong();
    private final AtomicInteger waitQueueLength = new AtomicInteger();

    StatisticsHolder() {
    }

    Map<StatisticsKey, Long> getStatistics(Number lastCheck) {
        ImmutableMap.Builder stats = ImmutableMap.builder();
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.FAIL_LOCAL, this.failLocal);
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.FAIL_REMOTE, this.failRemote);
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.FORCED_UNLOCK, this.forcedUnlock);
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.LAST_ACCESS, Math.max(lastCheck.longValue(), this.lastStateChangeAt.get()));
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.SUCCESSFUL_LOCKS, this.lock);
        StatisticsHolder.addStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.WAIT_QUEUE_LENGTH, this.waitQueueLength);
        StatisticsHolder.addAverageStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.AVERAGE_HOLD_TIME_MILLIS, this.totalHoldTimeMillis, this.unlock);
        StatisticsHolder.addAverageStat((ImmutableMap.Builder<StatisticsKey, Long>)stats, StatisticsKey.AVERAGE_WAIT_TIME_MILLIS, this.totalWaitTimeMillis, this.totalWaits);
        return stats.build();
    }

    void tallyFailLocal() {
        this.failLocal.incrementAndGet();
    }

    void tallyFailRemote() {
        this.failRemote.incrementAndGet();
    }

    void tallyForcedUnlock() {
        this.forcedUnlock.incrementAndGet();
    }

    void tallyLockedAt(long currentTimeMillis) {
        this.lastStateChangeAt.set(currentTimeMillis);
        this.lock.incrementAndGet();
    }

    void tallyUnlockedAt(long currentTimeMillis) {
        long since = this.lastStateChangeAt.getAndSet(currentTimeMillis);
        if (currentTimeMillis > since) {
            this.totalHoldTimeMillis.addAndGet(currentTimeMillis - since);
        }
        this.unlock.incrementAndGet();
    }

    void tallyWaitBegin() {
        this.waitQueueLength.incrementAndGet();
    }

    void tallyWaitEndAfter(long durationInMillis) {
        this.waitQueueLength.decrementAndGet();
        if (durationInMillis > 0L) {
            this.totalWaitTimeMillis.addAndGet(durationInMillis);
        }
        this.totalWaits.incrementAndGet();
    }

    private static void addStat(ImmutableMap.Builder<StatisticsKey, Long> stats, StatisticsKey key, Number valueHolder) {
        long value = valueHolder.longValue();
        if (value > 0L) {
            stats.put((Object)key, (Object)value);
        }
    }

    private static void addAverageStat(ImmutableMap.Builder<StatisticsKey, Long> stats, StatisticsKey key, Number total, Number eventCount) {
        long avg;
        long events = eventCount.longValue();
        if (events > 0L && (avg = total.longValue() / events) > 0L) {
            stats.put((Object)key, (Object)avg);
        }
    }
}

