/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.db;

import com.atlassian.beehive.db.ClusterNodeHeartbeatService;
import com.atlassian.beehive.db.spi.ClusterNodeHeartBeatDao;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractClusterNodeHeartbeatService
implements ClusterNodeHeartbeatService {
    private static final JobRunnerKey HEART_BEAT_JOB_RUNNER_KEY = JobRunnerKey.of((String)ClusterNodeHeartbeatService.class.getName());
    private static final long MINUTE = 60000L;
    static final long TIMEOUT = 300000L;
    private final ClusterNodeHeartBeatDao clusterNodeHeartBeatDao;
    private final SchedulerService schedulerService;

    public AbstractClusterNodeHeartbeatService(ClusterNodeHeartBeatDao clusterNodeHeartBeatDao, SchedulerService schedulerService) {
        this.clusterNodeHeartBeatDao = clusterNodeHeartBeatDao;
        this.schedulerService = schedulerService;
    }

    protected void startHeartbeat() throws SchedulerServiceException {
        this.schedulerService.registerJobRunner(HEART_BEAT_JOB_RUNNER_KEY, this.newHeartbeatJobRunner());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)HEART_BEAT_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)60000L, null));
        this.schedulerService.scheduleJob(JobId.of((String)ClusterNodeHeartbeatService.class.getName()), jobConfig);
    }

    @Override
    @Nonnull
    public String getNodeId() {
        return this.clusterNodeHeartBeatDao.getNodeId();
    }

    @Override
    public boolean isNodeLive(@Nonnull String nodeId) {
        Long lastHeartbeat = this.getLastHeartbeatTime(nodeId);
        if (lastHeartbeat == null) {
            return false;
        }
        long elapsedTime = System.currentTimeMillis() - lastHeartbeat;
        return elapsedTime < 300000L;
    }

    @Override
    public Long getLastHeartbeatTime(@Nonnull String nodeId) {
        return this.clusterNodeHeartBeatDao.getLastHeartbeatTime(nodeId);
    }

    @Override
    @Nonnull
    public Collection<String> findLiveNodes() {
        return this.findLiveNodes(300000L);
    }

    @Override
    @Nonnull
    public Collection<String> findLiveNodes(long threshold) {
        return this.clusterNodeHeartBeatDao.findNodesWithHeartbeatsAfter(System.currentTimeMillis() - threshold);
    }

    protected JobRunner newHeartbeatJobRunner() {
        return new HeartbeatJobRunner();
    }

    private class HeartbeatJobRunner
    implements JobRunner {
        private HeartbeatJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
            AbstractClusterNodeHeartbeatService.this.clusterNodeHeartBeatDao.writeHeartBeat(System.currentTimeMillis());
            return JobRunnerResponse.success();
        }
    }
}

