/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = -5270791443693616427L;
    private final String localizedMessage;
    private final String messageKey;
    private transient KeyedMessage keyedMessage;

    public ServiceException(@Nonnull KeyedMessage message) {
        this(message, null);
    }

    public ServiceException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(Objects.requireNonNull(message, "message").getRootMessage(), cause);
        this.localizedMessage = message.getLocalisedMessage();
        this.messageKey = message.getKey();
        this.keyedMessage = message;
    }

    @Nonnull
    public KeyedMessage getKeyedMessage() {
        if (this.keyedMessage == null) {
            this.keyedMessage = new KeyedMessage(this.messageKey, this.localizedMessage, this.getMessage());
        }
        return this.keyedMessage;
    }

    @Override
    @Nonnull
    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    @Nonnull
    public String getMessageKey() {
        return this.messageKey;
    }
}

