/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpdateMeshNodeRequest {
    private final long id;
    private final String name;
    private final String rpcUrl;

    private UpdateMeshNodeRequest(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.rpcUrl = builder.rpcUrl;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getRpcUrl() {
        return this.rpcUrl;
    }

    public static class Builder {
        private final long id;
        private String name;
        private String rpcUrl;

        public Builder(@Nonnull MeshNode node) {
            this(Objects.requireNonNull(node, "node").getId());
        }

        public Builder(long id) {
            this.id = id;
        }

        @Nonnull
        public UpdateMeshNodeRequest build() {
            return new UpdateMeshNodeRequest(this);
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Objects.requireNonNull(value, "name");
            return this;
        }

        @Nonnull
        public Builder rpcUrl(@Nonnull String value) {
            this.rpcUrl = Objects.requireNonNull(value, "rpcUrl");
            return this;
        }
    }
}

