/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.comment;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.comment.RestCommentThreadDiffAnchor;
import com.atlassian.bitbucket.rest.property.RestPropertySupport;
import com.atlassian.bitbucket.rest.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.task.RestTask;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.task.Task;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Comment.class)
public class RestComment
extends RestPropertySupport {
    public static final Function<Comment, RestComment> REST_TRANSFORM = new Function<Comment, RestComment>(){

        @Override
        public RestComment apply(Comment comment) {
            return new RestComment(comment, this);
        }
    };
    public static final RestComment REQUEST_EXAMPLE_ID = new RestComment(1L, null, null, null, null, null, null, null, null, null, null, null);
    public static final RestComment REQUEST_EXAMPLE = new RestComment(0L, null, "An insightful comment.", RestCommentThreadDiffAnchor.LINE_REQUEST_MINIMUM_EXAMPLE, null, null, null, REQUEST_EXAMPLE_ID, null, null, null, null);
    public static final RestComment REQUEST_EXISTING_EXAMPLE = new RestComment(0L, 0, "A pithy comment.", null, null, null, null, null, null, null, null, null);
    public static final RestComment RESPONSE_EXAMPLE_NO_REPLY = new RestComment(1L, 1, "An insightful comment.", null, RestApplicationUser.RESPONSE_EXAMPLE, new Date(), new Date(), null, Lists.newArrayList(), (Map<String, Boolean>)ImmutableMap.of((Object)"editable", (Object)true, (Object)"deletable", (Object)true), new PropertyMap.Builder().property("key", (Object)"value").build(), Lists.newArrayList());
    public static final RestComment RESPONSE_EXAMPLE = new RestComment(1L, 1, "A measured reply.", null, RestApplicationUser.RESPONSE_EXAMPLE, new Date(), new Date(), null, Lists.newArrayList((Object[])new RestComment[]{RESPONSE_EXAMPLE_NO_REPLY}), (Map<String, Boolean>)ImmutableMap.of((Object)"editable", (Object)true, (Object)"deletable", (Object)true), new PropertyMap.Builder().property("key", (Object)"value").build(), Lists.newArrayList());

    public RestComment() {
    }

    public RestComment(Map<String, Object> values) {
        this.putAll(values);
    }

    public RestComment(@Nonnull Comment comment) {
        this(comment, REST_TRANSFORM);
    }

    public RestComment(CommentThread thread) {
        this(thread.getRootComment(), thread.getAnchor().map(RestCommentThreadDiffAnchor::new).orElse(null), REST_TRANSFORM);
        this.putIfNotNull("pullRequest", thread.getCommentable().accept((CommentableVisitor)new CommentableVisitor<RestPullRequest>(){

            public RestPullRequest visit(@Nonnull CommitDiscussion discussion) {
                return null;
            }

            public RestPullRequest visit(@Nonnull PullRequest pullRequest) {
                return new RestPullRequest(pullRequest);
            }
        }));
    }

    public RestComment(@Nonnull Comment comment, @Nullable Function<Comment, RestComment> replyTransformer) {
        this(comment, null, replyTransformer);
    }

    public RestComment(@Nonnull Comment comment, @Nullable RestCommentThreadDiffAnchor anchor, @Nullable Function<Comment, RestComment> replyTransformer) {
        this(comment, anchor, replyTransformer, RestTask.REST_TRANSFORM);
    }

    public RestComment(@Nonnull Comment comment, @Nullable RestCommentThreadDiffAnchor anchor, @Nullable Function<Comment, RestComment> replyTransformer, @Nullable Function<Task, RestTask> taskTransformer) {
        this(comment.getId(), comment.getVersion(), comment.getText(), anchor, new RestApplicationUser(comment.getAuthor()), comment.getCreatedDate(), comment.getUpdatedDate(), null, replyTransformer == null ? null : RestComment.transform((Iterable)comment.getComments(), replyTransformer), comment.getProperties(), taskTransformer == null ? null : RestComment.transform((Iterable)comment.getTasks(), taskTransformer));
        comment.getPermittedOperations().ifPresent(operations -> {
            HashMap permittedOperations = Maps.newHashMap();
            permittedOperations.put("editable", operations.isEditable());
            permittedOperations.put("deletable", operations.isDeletable());
            this.put("permittedOperations", permittedOperations);
        });
    }

    private RestComment(long id, Integer version, String text, RestCommentThreadDiffAnchor anchor, RestApplicationUser author, Date created, Date updated, RestComment parent, List<RestComment> replies, Map<String, Boolean> permittedOperations, PropertyMap properties, List<RestTask> tasks) {
        this(id, version, text, anchor, author, created, updated, parent, replies, properties, tasks);
        this.putIfNotEmpty("permittedOperations", permittedOperations);
    }

    private RestComment(long id, Integer version, String text, RestCommentThreadDiffAnchor anchor, RestApplicationUser author, Date created, Date updated, RestComment parent, List<RestComment> replies, PropertyMap properties, List<RestTask> tasks) {
        super((Map<String, Object>)properties);
        if (id > 0L) {
            this.put("id", id);
        }
        this.putIfNotNull("version", version);
        this.putIfNotNull("text", text);
        this.putIfNotNull("author", author);
        this.putIfNotNull("createdDate", created);
        this.putIfNotNull("updatedDate", updated);
        this.putIfNotNull("comments", replies);
        this.putIfNotNull("parent", (Object)parent);
        this.putIfNotNull("anchor", (Object)anchor);
        this.putIfNotNull("tasks", tasks);
    }

    public RestCommentThreadDiffAnchor getAnchor() {
        Object anchor = this.get("anchor");
        if (anchor instanceof RestCommentThreadDiffAnchor) {
            return (RestCommentThreadDiffAnchor)((Object)anchor);
        }
        if (anchor instanceof Map) {
            return new RestCommentThreadDiffAnchor((Map)anchor);
        }
        return null;
    }

    public long getId() {
        return this.getLongProperty("id");
    }

    public RestComment getParent() {
        Object parent = this.get("parent");
        if (parent instanceof RestComment) {
            return (RestComment)((Object)parent);
        }
        if (parent instanceof Map) {
            return new RestComment((Map)parent);
        }
        return null;
    }

    public String getText() {
        return this.getStringProperty("text");
    }

    public void setHtml(String html) {
        this.put("html", html);
    }

    public int getVersion() {
        return this.getIntProperty("version");
    }

    public boolean isAnchored() {
        return this.containsKey("anchor");
    }

    public boolean isReply() {
        return this.containsKey("parent");
    }
}

