/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.hook.repository;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVeto;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.rest.RestErrorMessage;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.hook.repository.RestRepositoryHookTrigger;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.base.MoreObjects;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=RepositoryHookVetoedException.class)
public class RestRepositoryHookVetoedMessage
extends RestErrorMessage {
    public RestRepositoryHookVetoedMessage(RepositoryHookVetoedException e) {
        super((ServiceException)e);
        this.put("details", e.getVetoes().stream().map(RestRepositoryHookVetoedMessage::toDetailString).collect(MoreCollectors.toImmutableList()));
        this.put("trigger", (Object)new RestRepositoryHookTrigger(e.getRequest().getTrigger()));
    }

    private static String toDetailString(RepositoryHookVeto veto) {
        if (StringUtils.isBlank((CharSequence)veto.getSummaryMessage()) || StringUtils.equalsIgnoreCase((CharSequence)veto.getSummaryMessage(), (CharSequence)veto.getDetailedMessage())) {
            return (String)MoreObjects.firstNonNull((Object)veto.getDetailedMessage(), (Object)"");
        }
        if (StringUtils.isBlank((CharSequence)veto.getDetailedMessage())) {
            return veto.getSummaryMessage();
        }
        return veto.getSummaryMessage() + "\n" + veto.getDetailedMessage();
    }
}

