/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.pull;

import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.pull.RestPullRequestMergeStrategy;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PullRequestMergeConfig.class)
public class RestPullRequestMergeConfig
extends RestMapEntity {
    private static final String DEFAULT_STRATEGY = "defaultStrategy";
    private static final String STRATEGIES = "strategies";
    private static final String TYPE = "type";
    public static final RestPullRequestMergeConfig REQUEST_EXAMPLE = new RestPullRequestMergeConfig(RestPullRequestMergeStrategy.REQUEST_EXAMPLE, Collections.singleton(RestPullRequestMergeStrategy.REQUEST_EXAMPLE), null);
    public static final RestPullRequestMergeConfig RESPONSE_EXAMPLE = new RestPullRequestMergeConfig(RestPullRequestMergeStrategy.RESPONSE_EXAMPLE, Collections.singleton(RestPullRequestMergeStrategy.RESPONSE_EXAMPLE), "repository");

    public RestPullRequestMergeConfig() {
    }

    public RestPullRequestMergeConfig(PullRequestMergeConfig config) {
        this(new RestPullRequestMergeStrategy(config.getDefaultStrategy()), RestPullRequestMergeConfig.transform((Set)config.getStrategies(), RestPullRequestMergeStrategy::new), config.getType().name());
    }

    private RestPullRequestMergeConfig(Map<String, ?> values) {
        super(values);
    }

    private RestPullRequestMergeConfig(RestPullRequestMergeStrategy defaultStrategy, Set<RestPullRequestMergeStrategy> strategies, String type) {
        this.put(DEFAULT_STRATEGY, (Object)defaultStrategy);
        this.put(STRATEGIES, strategies);
        this.putIfNotNull(TYPE, type);
    }

    @Nullable
    public static RestPullRequestMergeConfig valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequestMergeConfig) {
            return (RestPullRequestMergeConfig)((Object)value);
        }
        if (value instanceof Map) {
            return new RestPullRequestMergeConfig((Map)value);
        }
        return null;
    }

    @Nullable
    public RestPullRequestMergeStrategy getDefaultStrategy() {
        return RestPullRequestMergeStrategy.valueOf(this.get(DEFAULT_STRATEGY));
    }

    @Nonnull
    public Set<RestPullRequestMergeStrategy> getStrategies() {
        Object strategies = this.get(STRATEGIES);
        if (strategies instanceof Iterable) {
            return (Set)MoreStreams.streamIterable((Iterable)((Iterable)strategies)).map(RestPullRequestMergeStrategy::valueOf).filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
        }
        if (strategies instanceof RestPullRequestMergeStrategy) {
            return Collections.singleton((RestPullRequestMergeStrategy)((Object)strategies));
        }
        return Collections.emptySet();
    }

    @Nullable
    public String getType() {
        return this.getStringProperty(TYPE);
    }
}

