/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.repository;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.repository.RestBranch;
import com.atlassian.bitbucket.rest.repository.RestRef;
import com.atlassian.bitbucket.rest.repository.RestTag;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=MinimalRef.class)
public class RestMinimalRef
extends RestMapEntity
implements MinimalRef {
    public static final Function<MinimalRef, RestMinimalRef> REST_TRANSFORM = ref -> {
        if (ref == null) {
            return null;
        }
        if (ref instanceof Branch) {
            return new RestBranch((Branch)ref);
        }
        if (ref instanceof Tag) {
            return new RestTag((Tag)ref);
        }
        return ref instanceof Ref ? new RestRef((Ref)ref) : new RestMinimalRef((MinimalRef)ref);
    };
    protected static final String DISPLAY_ID = "displayId";
    protected static final String ID = "id";
    protected static final String TYPE = "type";
    public static final RestMinimalRef RESPONSE_EXAMPLE = new RestMinimalRef("refs/heads/mybranch", "mybranch", (RefType)StandardRefType.BRANCH);

    private RestMinimalRef(Map<String, Object> map) {
        super(map);
    }

    public RestMinimalRef() {
    }

    public RestMinimalRef(MinimalRef ref) {
        this(ref.getId(), ref.getDisplayId(), ref.getType());
    }

    protected RestMinimalRef(String id, String displayId, RefType type) {
        this.put(ID, id);
        this.put(DISPLAY_ID, displayId);
        this.put(TYPE, type.toString());
    }

    @Nonnull
    public String getDisplayId() {
        return this.getStringProperty(DISPLAY_ID);
    }

    @Nonnull
    public String getId() {
        return this.getStringProperty(ID);
    }

    @Nonnull
    public RefType getType() {
        return (RefType)this.getEnumProperty(TYPE, StandardRefType.class, null);
    }

    @Nullable
    public static RestMinimalRef valueOf(@Nullable Object value) {
        if (value instanceof RestMinimalRef) {
            return (RestMinimalRef)((Object)value);
        }
        if (value instanceof Map) {
            return new RestMinimalRef((Map)value);
        }
        if (value instanceof MinimalRef) {
            return new RestMinimalRef((MinimalRef)value);
        }
        return null;
    }
}

