/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestNamedLink;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestRelatedLinks;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Repository.class)
public class RestRepository
extends RestLinkedMapEntity {
    private static final String FORKABLE = "forkable";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ORIGIN = "origin";
    private static final String PUBLIC = "public";
    private static final String PROJECT = "project";
    private static final String SCM_ID = "scmId";
    private static final String SLUG = "slug";
    private static final String STATE = "state";
    private static final String STATUS_MESSAGE = "statusMessage";
    public static final Function<Repository, RestRepository> REST_TRANSFORM = RestRepository::new;
    public static final RestRepository REQUEST_EXAMPLE_FOR_UPDATE = new RestRepository(0, null, "My repo", null, null, null, false, null, RestProject.REQUEST_EXAMPLE_KEY_ONLY, true, null);
    public static final RestRepository REQUEST_EXAMPLE_NAME_ONLY = new RestRepository(0, null, "My repo", null, null, null, null, null, null, null, null);
    public static final RestRepository REQUEST_EXAMPLE_WITH_PROJECT = new RestRepository(0, "my-repo", null, null, null, null, null, null, RestProject.REQUEST_EXAMPLE_KEY_ONLY, null, null);
    public static final RestRepository REQUEST_EXAMPLE = new RestRepository(0, null, "My repo", "git", null, null, true, null, null, null, null);
    public static final RestRepository RESPONSE_EXAMPLE = new RestRepository(1, "my-repo", "My repo", "git", Repository.State.AVAILABLE, "Available", true, null, RestProject.RESPONSE_EXAMPLE, true, new RestRelatedLinks.Builder().addRelatedLink("self", RestDocUtils.selfLink(Repository.class)).addRelatedLinks("clone", Arrays.asList(new RestNamedLink(RestRepository.httpCloneUrl("PRJ", "my-repo"), "http"), new RestNamedLink(RestRepository.sshCloneUrl("PRJ", "my-repo"), "ssh"))).build());
    public static final RestRepository RESPONSE_EXAMPLE_WITH_ORIGIN = new RestRepository(2, "my-repo", "My repo", "git", Repository.State.AVAILABLE, "Available", true, RESPONSE_EXAMPLE, RestProject.RESPONSE_EXAMPLE_PERSONAL, null, new RestRelatedLinks.Builder().addRelatedLink("self", RestDocUtils.selfLink(Repository.class)).addRelatedLinks("clone", Arrays.asList(new RestNamedLink(RestRepository.httpCloneUrl("JDOE", "my-repo"), "http"), new RestNamedLink(RestRepository.sshCloneUrl("JDOE", "my-repo"), "ssh"))).build());
    public static final RestPage<RestRepository> PAGE_EXAMPLE = RestDocUtils.pageOf(RESPONSE_EXAMPLE);
    public static final RestPage<RestRepository> PAGE_EXAMPLE_FOR_FORKS = RestDocUtils.pageOf(RESPONSE_EXAMPLE_WITH_ORIGIN);

    public RestRepository() {
    }

    public RestRepository(Repository repository) {
        this(repository, true);
    }

    public RestRepository(Repository repository, boolean includeProject) {
        this(repository.getId(), repository.getSlug(), repository.getName(), repository.getScmId(), repository.getState(), repository.getStatusMessage(), repository.isForkable(), repository.getOrigin() == null ? null : new RestRepository(repository.getOrigin(), includeProject), includeProject ? RestProject.fromProject(repository.getProject()) : null, repository.isPublic());
    }

    private RestRepository(int id, String slug, String name, String scmId, Repository.State state, String statusMessage, Boolean forkable, RestRepository origin, RestProject project, Boolean publiclyAccessible) {
        this.putIfNotNull(SLUG, slug);
        if (id > 0) {
            this.put(ID, id);
        }
        this.put(NAME, name);
        this.putIfNotNull(SCM_ID, scmId);
        this.putIfNotNull(STATE, state);
        this.putIfNotNull(STATUS_MESSAGE, statusMessage);
        this.putIfNotNull(FORKABLE, forkable);
        this.putIfNotNull(ORIGIN, (Object)origin);
        this.putIfNotNull(PROJECT, project);
        this.putIfNotNull(PUBLIC, publiclyAccessible);
    }

    private RestRepository(int id, String slug, String name, String scmId, Repository.State state, String statusMessage, Boolean forkable, RestRepository origin, RestProject project, Boolean publiclyAccessible, RestRelatedLinks relatedLinks) {
        this(id, slug, name, scmId, state, statusMessage, forkable, origin, project, publiclyAccessible);
        this.setLinks(relatedLinks);
    }

    private RestRepository(Map<String, Object> values) {
        super(values);
    }

    public String getName() {
        return this.getStringProperty(NAME);
    }

    public int getId() {
        return this.getIntProperty(ID);
    }

    public RestProject getProject() {
        return RestProject.valueOf(this.get(PROJECT));
    }

    public String getScmId() {
        return this.getStringProperty(SCM_ID);
    }

    public String getSlug() {
        return this.getStringProperty(SLUG);
    }

    public boolean hasForkable() {
        return this.get(FORKABLE) != null;
    }

    public boolean hasProject() {
        return this.getProject() != null;
    }

    public boolean hasPublic() {
        return this.get(PUBLIC) != null;
    }

    public boolean isForkable() {
        return this.getBoolProperty(FORKABLE, true);
    }

    public boolean isPublic() {
        return this.getBoolProperty(PUBLIC, false);
    }

    @Nullable
    public static RestRepository valueOf(@Nullable Object value) {
        if (value instanceof RestRepository) {
            return (RestRepository)((Object)value);
        }
        if (value instanceof Map) {
            return new RestRepository((Map)value);
        }
        return null;
    }

    private static String httpCloneUrl(String projKey, String repoSlug) {
        return "https://<baseURL>/scm/" + projKey + "/" + repoSlug + ".git";
    }

    private static String sshCloneUrl(String projKey, String repoSlug) {
        return "ssh://git@<baseURL>/" + projKey + "/" + repoSlug + ".git";
    }
}

