/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.repository;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.pull.RestPullRequestMergeConfig;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

public class RestRepositoryPullRequestSettings
extends RestMapEntity {
    private static final String MERGE_CONFIG = "mergeConfig";
    private static final String REQUIRED_ALL_APPROVERS = "requiredAllApprovers";
    private static final String REQUIRED_ALL_TASKS_COMPLETE = "requiredAllTasksComplete";
    private static final String REQUIRED_APPROVERS = "com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook";
    private static final String REQUIRED_APPROVERS_DEPRECATED = "requiredApprovers";
    private static final String REQUIRED_SUCCESSFUL_BUILDS = "com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck";
    private static final String REQUIRED_SUCCESSFUL_BUILDS_DEPRECATED = "requiredSuccessfulBuilds";
    public static final RestRepositoryPullRequestSettings REQUEST_EXAMPLE = new RestRepositoryPullRequestSettings(false, false, (Map<String, Object>)ImmutableMap.of((Object)"enabled", (Object)true, (Object)"count", (Object)2), (Map<String, Object>)ImmutableMap.of((Object)"enabled", (Object)true, (Object)"count", (Object)3), RestPullRequestMergeConfig.REQUEST_EXAMPLE);
    public static final RestRepositoryPullRequestSettings RESPONSE_EXAMPLE = new RestRepositoryPullRequestSettings(false, false, (Map<String, Object>)ImmutableMap.of((Object)"enabled", (Object)true, (Object)"count", (Object)2), (Map<String, Object>)ImmutableMap.of((Object)"enabled", (Object)true, (Object)"count", (Object)3), RestPullRequestMergeConfig.RESPONSE_EXAMPLE);

    public RestRepositoryPullRequestSettings() {
    }

    private RestRepositoryPullRequestSettings(boolean requiredAllApprovers, boolean requiredAllTasksComplete, Map<String, Object> requiredApprovers, Map<String, Object> requiredBuilds, RestPullRequestMergeConfig mergeConfig) {
        this.put(MERGE_CONFIG, (Object)mergeConfig);
        this.put(REQUIRED_ALL_APPROVERS, requiredAllApprovers);
        this.put(REQUIRED_ALL_TASKS_COMPLETE, requiredAllTasksComplete);
        this.put(REQUIRED_APPROVERS, requiredApprovers);
        this.put(REQUIRED_APPROVERS_DEPRECATED, requiredApprovers.get("count"));
        this.put(REQUIRED_SUCCESSFUL_BUILDS, requiredBuilds);
        this.put(REQUIRED_SUCCESSFUL_BUILDS_DEPRECATED, requiredApprovers.get("count"));
    }

    @Nullable
    public RestPullRequestMergeConfig getMergeConfig() {
        return RestPullRequestMergeConfig.valueOf(this.get(MERGE_CONFIG));
    }

    public boolean getRequiredAllApprovers() {
        return this.getBoolProperty(REQUIRED_ALL_APPROVERS);
    }

    public boolean getRequiredAllTasksComplete() {
        return this.getBoolProperty(REQUIRED_ALL_TASKS_COMPLETE);
    }

    public Map<String, Object> getRequiredApprovers() {
        return (Map)this.get(REQUIRED_APPROVERS);
    }

    public int getRequiredApproversDeprecated() {
        return this.getIntProperty(REQUIRED_APPROVERS_DEPRECATED);
    }

    public Map<String, Object> getRequiredSuccessfulBuilds() {
        return (Map)this.get(REQUIRED_SUCCESSFUL_BUILDS);
    }

    public int getRequiredSuccessfulBuildsDeprecated() {
        return this.getIntProperty(REQUIRED_SUCCESSFUL_BUILDS_DEPRECATED);
    }
}

