/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.scope;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Scope.class)
public class RestScope
extends RestMapEntity
implements Scope {
    private static final String RESOURCE_ID = "resourceId";
    private static final String TYPE = "type";
    public static final RestScope REPOSITORY_SCOPE_EXAMPLE = new RestScope(2, ScopeType.REPOSITORY);

    public RestScope(@Nonnull Scope scope) {
        this.put(TYPE, Objects.requireNonNull(scope, "scope").getType().name());
        scope.getResourceId().ifPresent(id -> this.put(RESOURCE_ID, id));
    }

    private RestScope(Map<String, Object> object) {
        super(object);
    }

    private RestScope(int resourceId, ScopeType type) {
        this.put(RESOURCE_ID, resourceId);
        this.put(TYPE, type);
    }

    public <T> T accept(@Nonnull ScopeVisitor<T> visitor) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass() + " is not intended to be visited");
    }

    @Nonnull
    public Optional<Integer> getResourceId() {
        int resourceId = this.getIntProperty(RESOURCE_ID);
        return resourceId == -1 ? Optional.empty() : Optional.of(resourceId);
    }

    @Nonnull
    public ScopeType getType() {
        return (ScopeType)this.getEnumProperty(TYPE, ScopeType.class);
    }

    @Nullable
    public static RestScope valueOf(@Nullable Object object) {
        if (object instanceof RestScope) {
            return (RestScope)((Object)object);
        }
        if (object instanceof Map) {
            return new RestScope((Map)object);
        }
        return null;
    }
}

