/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.FilePermission;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.SetFilePermissionRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class FileUtils {
    private static final Set<AclEntryPermission> EXECUTE_ACL_PERMISSIONS = ImmutableSet.of((Object)((Object)AclEntryPermission.EXECUTE));
    private static final Set<AclEntryPermission> READ_ACL_PERMISSIONS = ImmutableSet.of((Object)((Object)AclEntryPermission.READ_ACL), (Object)((Object)AclEntryPermission.READ_ATTRIBUTES), (Object)((Object)AclEntryPermission.READ_DATA), (Object)((Object)AclEntryPermission.READ_NAMED_ATTRS));
    private static final Set<AclEntryPermission> WRITE_ACL_PERMISSIONS = ImmutableSet.of((Object)((Object)AclEntryPermission.WRITE_ACL), (Object)((Object)AclEntryPermission.WRITE_ATTRIBUTES), (Object)((Object)AclEntryPermission.WRITE_DATA), (Object)((Object)AclEntryPermission.WRITE_NAMED_ATTRS), (Object)((Object)AclEntryPermission.WRITE_OWNER), (Object)((Object)AclEntryPermission.APPEND_DATA), (Object[])new AclEntryPermission[]{AclEntryPermission.DELETE, AclEntryPermission.DELETE_CHILD, AclEntryPermission.SYNCHRONIZE});

    private FileUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static File construct(@Nonnull File base, String ... segments) {
        return segments.length == 0 ? base : new File(base, FileUtils.join(segments));
    }

    @Nonnull
    public static File createTempDir(@Nonnull String prefix, @Nullable String suffix, @Nullable File directory) throws IOException {
        File temporary = File.createTempFile(prefix, suffix, directory);
        if (temporary.delete() && temporary.mkdir()) {
            return temporary;
        }
        throw new IOException("Could not create directory: " + temporary);
    }

    @Nonnull
    public static String join(String ... segments) {
        return StringUtils.join((Object[])segments, (String)File.separator);
    }

    public static void mkdir(@Nonnull File directory) {
        Preconditions.checkNotNull((Object)directory, (Object)"directory");
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalStateException(directory.getAbsolutePath() + " already exists and is not a directory");
            }
        } else if (!directory.mkdirs()) {
            throw new IllegalStateException("Could not create " + directory.getAbsolutePath());
        }
    }

    @Nonnull
    public static File mkdir(@Nonnull String path) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)path, (Object)"path")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A path for the created directory is required");
        File dir = new File(path);
        FileUtils.mkdir(dir);
        return dir;
    }

    @Nonnull
    public static File mkdir(@Nullable File parent, @Nonnull String child) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)child, (Object)"child")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A path for the created directory is required");
        File dir = new File(parent, child);
        FileUtils.mkdir(dir);
        return dir;
    }

    public static void setFilePermission(@Nonnull SetFilePermissionRequest request) throws IOException {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        File file = request.getFile();
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"The provided file does not exist or is not a file");
        Path path = file.toPath();
        if (SystemUtils.IS_OS_WINDOWS) {
            Set<FilePermission> worldPermissions;
            AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            UserPrincipalLookupService principalService = path.getFileSystem().getUserPrincipalLookupService();
            ImmutableList.Builder entries = ImmutableList.builder();
            Set<FilePermission> ownerPermissions = request.getOwnerPermissions();
            if (!ownerPermissions.isEmpty()) {
                entries.add((Object)FileUtils.createAclEntry(Files.getOwner(path, new LinkOption[0]), ownerPermissions));
                FileUtils.createAclEntry(principalService, "administrators", ownerPermissions).ifPresent(arg_0 -> ((ImmutableList.Builder)entries).add(arg_0));
            }
            if (!(worldPermissions = request.getWorldPermissions()).isEmpty()) {
                FileUtils.createAclEntry(principalService, "everyone", request.getWorldPermissions()).ifPresent(arg_0 -> ((ImmutableList.Builder)entries).add(arg_0));
            }
            view.setAcl((List<AclEntry>)entries.build());
        } else {
            try {
                Files.setPosixFilePermissions(path, FileUtils.toPosixFilePermissions(request));
            }
            catch (UnsupportedOperationException e) {
                throw new IOException("Failed to update file permissions for " + file.getAbsolutePath(), e);
            }
        }
    }

    private static AclEntry createAclEntry(UserPrincipal principal, Set<FilePermission> permissions) {
        return AclEntry.newBuilder().setPermissions((Set)permissions.stream().flatMap(permission -> {
            switch (permission) {
                case EXECUTE: {
                    return EXECUTE_ACL_PERMISSIONS.stream();
                }
                case READ: {
                    return READ_ACL_PERMISSIONS.stream();
                }
            }
            return WRITE_ACL_PERMISSIONS.stream();
        }).collect(MoreCollectors.toImmutableSet())).setPrincipal(principal).setType(AclEntryType.ALLOW).build();
    }

    private static Optional<AclEntry> createAclEntry(UserPrincipalLookupService principalService, String principalName, Set<FilePermission> permissions) throws IOException {
        try {
            return Optional.of(FileUtils.createAclEntry(principalService.lookupPrincipalByGroupName(principalName), permissions));
        }
        catch (UserPrincipalNotFoundException e) {
            return Optional.empty();
        }
    }

    private static Set<PosixFilePermission> toPosixFilePermissions(SetFilePermissionRequest request) {
        ImmutableSet.Builder posixPermissions = ImmutableSet.builder();
        request.getOwnerPermissions().stream().map(permission -> {
            switch (permission) {
                case EXECUTE: {
                    return PosixFilePermission.OWNER_EXECUTE;
                }
                case READ: {
                    return PosixFilePermission.OWNER_READ;
                }
            }
            return PosixFilePermission.OWNER_WRITE;
        }).forEach(arg_0 -> ((ImmutableSet.Builder)posixPermissions).add(arg_0));
        request.getGroupPermissions().stream().map(permission -> {
            switch (permission) {
                case EXECUTE: {
                    return PosixFilePermission.GROUP_EXECUTE;
                }
                case READ: {
                    return PosixFilePermission.GROUP_READ;
                }
            }
            return PosixFilePermission.GROUP_WRITE;
        }).forEach(arg_0 -> ((ImmutableSet.Builder)posixPermissions).add(arg_0));
        request.getWorldPermissions().stream().map(permission -> {
            switch (permission) {
                case EXECUTE: {
                    return PosixFilePermission.OTHERS_EXECUTE;
                }
                case READ: {
                    return PosixFilePermission.OTHERS_READ;
                }
            }
            return PosixFilePermission.OTHERS_WRITE;
        }).forEach(arg_0 -> ((ImmutableSet.Builder)posixPermissions).add(arg_0));
        return posixPermissions.build();
    }
}

