/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ShaUtils {
    public static final String NULL_SHA1 = StringUtils.repeat((String)"0", (int)40);

    private ShaUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static int compare(@Nonnull String hash1, @Nonnull String hash2) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)hash1), (Object)"hash1 is empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)hash2), (Object)"hash2 is empty");
        int length1 = hash1.length();
        int length2 = hash2.length();
        if (length1 == length2) {
            return hash1.compareTo(hash2);
        }
        int length = length1 < length2 ? length1 : length2;
        for (int i = 0; i < length; ++i) {
            int result = hash1.charAt(i) - hash2.charAt(i);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public static boolean hashesMatch(@Nullable String hash1, @Nullable String hash2) {
        if (hash1 == hash2) {
            return true;
        }
        if (hash1 == null || hash2 == null) {
            return Objects.equals(hash1, hash2);
        }
        return ShaUtils.compare(hash1, hash2) == 0;
    }
}

