/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternIterable<T>
implements Iterable<T> {
    private final Matcher matcher;
    private final Function<MatchResult, T> extractor;

    public PatternIterable(Pattern pattern, String text, Function<MatchResult, T> extractor) {
        this(pattern.matcher(text), extractor);
    }

    public PatternIterable(Matcher matcher, Function<MatchResult, T> extractor) {
        this.matcher = matcher;
        this.extractor = extractor;
    }

    @Override
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(){

            protected T computeNext() {
                return PatternIterable.this.matcher.find() ? PatternIterable.this.extractor.apply(PatternIterable.this.matcher.toMatchResult()) : this.endOfData();
            }
        };
    }

    public static Function<MatchResult, String> group(int n) {
        return matchResult -> matchResult.group(n);
    }
}

