/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.project.AbstractProjectVisitor;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.annotation.Nonnull;

public class IsPersonalProjectCondition
implements Condition {
    public static final String PROJECT = "project";
    public static final String ONLY_MINE = "onlyMine";
    private final AuthenticationContext authenticationContext;
    private boolean onlyMine;

    public IsPersonalProjectCondition(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) {
        this.onlyMine = Boolean.parseBoolean(params.get(ONLY_MINE));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Project project = (Project)context.get(PROJECT);
        if (project == null) {
            return false;
        }
        return (Boolean)project.accept((ProjectVisitor)new AbstractProjectVisitor<Boolean>(Boolean.FALSE){

            public Boolean visit(@Nonnull PersonalProject project) {
                return !IsPersonalProjectCondition.this.onlyMine || ApplicationUserEquality.equals((ApplicationUser)project.getOwner(), (Object)IsPersonalProjectCondition.this.authenticationContext.getCurrentUser());
            }
        });
    }
}

